<?php

// Exit if direct access.
if (!defined ('ABSPATH')) exit;

// Include Main Files
	
	require (FONT_FARSI_CLASS_DIR . '/class-custom-font-panel.php');
	require (FONT_FARSI_CLASS_DIR . '/class-help.php');
	require (FONT_FARSI_CLASS_DIR . '/class-wp-font.php');
	require (FONT_FARSI_CLASS_DIR . '/class-site-font.php');
	require (FONT_FARSI_CLASS_DIR . 'class.heading/h1font.php');
	require (FONT_FARSI_CLASS_DIR . 'class.heading/h2font.php');
	require (FONT_FARSI_CLASS_DIR . 'class.heading/h3font.php');
	require (FONT_FARSI_CLASS_DIR . 'class.heading/h4font.php');
	require (FONT_FARSI_CLASS_DIR . 'class.heading/h5font.php');
	require (FONT_FARSI_CLASS_DIR . 'class.heading/h6font.php');

class FONT_FARSI_HOME_CLASS {
// START CODING

public $menu_slug ="font-farsi-main";

	function __construct() {

	add_action( 'wp_head', [$this,'wp_head_output'] );	

	add_action( 'wp_head', [$this,'wp_head_output_custom_font'] );

	add_action( 'wp_head', [$this, 'amp_mode_font'] );

	add_action( 'wp_footer', [$this, 'convert_en_num_to_fa'] );

	add_action( 'admin_head', [$this,'main_wp_panel_font'] );

	add_action( 'admin_menu', [$this,'font_farsi_admin_panel'] );

	add_action( 'admin_menu', [$this, 'Custom_Font_Panel'] );

	add_action( 'admin_menu', [$this, 'Help_Panel'] );

	add_action( 'init', [$this,'font_farsi_load_textdomain']);

	add_action( 'admin_enqueue_scripts',[$this,'enqueue_admin_script']);

	add_action( 'wp_enqueue_scripts',[$this,'enqueue_wp_style']);

	add_action( 'admin_init', [$this ,'font_farsi_settings_register'], 10, 1 );

	add_action( 'admin_init', [$this , 'disable_gutenberg'], 10, 1 );

	add_action( 'plugin_action_links_' . plugin_basename( FONT_FARSI_FILE ) , [$this,'font_farsi_action_links'] );

	add_filter( 'plugin_row_meta', [$this, 'wpp_plugin_row_meta' ], 10, 2 );
	}

	// Plugin Action Links

	function font_farsi_action_links( $links ) {

	$links = array_merge( array(
		'<a href="' . esc_url( admin_url( '/admin.php?page=font-farsi-main' ) ) . '">' . esc_html__( 'Settings', 'font-farsi' ) . '</a>'
	),
	array(
		'<a href="' . esc_url( admin_url( '/admin.php?page=font-farsi-help' ) ) . '">' . esc_html__( 'Help', 'font-farsi' ) . '</a>'
	)
	, $links );

	return $links;

	}

	// Plugin Meta Links

public function wpp_plugin_row_meta( $links, $file ) {

	$site_link ="https://persian-vc.com/downloads/font-farsi/";

        if ( plugin_basename( FONT_FARSI_FILE ) == $file ) {
            $row_meta = array(

                'link-1'    => '<a href="' . esc_url( $site_link ) . '" target="_blank" aria-label="' . esc_attr__( 'Online Help', 'font-farsi'  ) . '" style="color:green;">' . esc_html__( 'Online Help', 'font-farsi'  ) . '</a>'
                ,
                 
                'link-2'		=> '<a href="' . esc_url( $site_link ) . '" target="_blank" aria-label="' . esc_attr__( 'Download Fonts', 'font-farsi'  ) . '" style="color:green;">' . esc_html__( 'Download Fonts', 'font-farsi'  ) . '</a>'
                ,

                'link-3'		=> '<a class="simptip-position-top simptip-success simptip-multiline" data-tooltip="' . esc_html__( 'Donate Me Text', 'font-farsi'  ) . '" href="' . esc_url( 'https://idpay.ir/persian-vc' ) . '" target="_blank" aria-label="' . esc_attr__( 'Donate Me', 'font-farsi'  ) . '" style="color:red;">' . esc_html__( 'Donate Me', 'font-farsi'  ) . '</a>'
            	);

            return array_merge( $links, $row_meta );
        }
        return (array) $links;
    }


	// Main Panel
	function font_farsi_admin_panel() {
		$page_title = esc_html__('Font Farsi Settings','font-farsi');
		$menu_title= esc_html__("Font Farsi",'font-farsi');
		$capability = "manage_options";
		$icon_url = "dashicons-editor-spellcheck";

		add_menu_page(
		$page_title,
		$menu_title,
		$capability,
		'font-farsi-main', 
		[ $this,'font_farsi_admin_menu_callback'],
		$icon_url,
		$position = 2 );
	}

	// Submenu: Custom Font

	function Custom_Font_Panel() {

		 $parent_slug = "font-farsi-main";
		 $page_title = esc_html__('Custom Font','font-farsi');
		 $menu_title = esc_html__('Custom Font','font-farsi');
		 $capability = "manage_options";
		 $menu_slug = "font-farsi-custom-font";

		add_submenu_page( 
		$parent_slug,
		$page_title,
		$menu_title,
		$capability,
		$menu_slug,
		[$this, 'Custom_Font_Panel_cb'] );
	}

	// Submenu: Help

	function Help_Panel() {
		 $parent_slug = "font-farsi-main";
		 $page_title = esc_html__("Font Farsi Help",'font-farsi');
		 $menu_title = esc_html__("Font Farsi Help",'font-farsi');
		 $capability = "manage_options";
		 $menu_slug = "font-farsi-help";

		add_submenu_page( 
		$parent_slug,
		$page_title,
		$menu_title,
		$capability,
		$menu_slug,
		[$this, 'Font_Farsi_Help_Panel_cb'] );
	}

	// Class_Custom_Font_Panel Call Back

	function Custom_Font_Panel_cb(){

		$custom_font_panel = new Class_Custom_Font_Panel ();
		$custom_font_panel->custom_font_panel_cb();

	}

	// Class_Custom_Css_Panel Call Back

	function Custom_Css_Panel_cb(){

		$Custom_Css_Panel = new Class_Custom_Css_Panel ();
		$Custom_Css_Panel->custom_css_panel_cb();

	}	

	// Font_Farsi_Help_Panel_cb

	function Font_Farsi_Help_Panel_cb() {
		$Help_Panel = new FONT_FARSI_HELP_CLASS ();
		$Help_Panel->help_output();

	}
	// Load Text Domain

	function font_farsi_load_textdomain() {
		
    #load_plugin_textdomain( 'font-farsi', false, dirname( plugin_basename( __FILE__ ) ) . '/../languages/' );
	load_textdomain('font-farsi', FONT_FARSI_LANGUAGE .'font-farsi-fa_IR.mo'); 
	}

	// Enqueue Admin Script

	function enqueue_admin_script() {
		
		wp_register_style('font-farsi-admin-css', FONT_FARSI_ASSETS_CSS_DIR .'admin-css.css');
		wp_enqueue_style('font-farsi-admin-css' );

		wp_register_style('font-farsi-admin-css-fonts-file', FONT_FARSI_ASSETS_URL .'fonts/fonts.css');
		wp_enqueue_style('font-farsi-admin-css-fonts-file');

		wp_register_style( 'simptip-css',  FONT_FARSI_ASSETS_CSS_DIR . 'simptip.css');
		wp_enqueue_style('simptip-css');

		wp_register_style( 'font-farsi-admin-spectrum-css',  FONT_FARSI_ASSETS_CSS_DIR . 'spectrum.css');
		wp_enqueue_style('font-farsi-admin-spectrum-css');

		wp_register_script('font-farsi-admin-js', FONT_FARSI_ASSETS_JS_DIR .'admin-js.js', array('jquery', 'jquery-ui-tooltip') ,false, false );
		wp_enqueue_script( 'font-farsi-admin-js' , array ('jquery') , null , true);

		wp_register_script('font-farsi-admin-heading-js', FONT_FARSI_ASSETS_JS_DIR .'admin-heading-js.js', array('jquery', 'jquery-ui-tooltip') ,false, false );
		wp_enqueue_script( 'font-farsi-admin-heading-js' , array ('jquery') , null , true);
		
		wp_register_script('font-farsi-admin-jscolor', FONT_FARSI_ASSETS_JS_DIR .'jscolor.js', array('jquery') ,false, false );
		wp_enqueue_script( 'font-farsi-admin-jscolor');	

		wp_register_script('font-farsi-admin-spectrum-js', FONT_FARSI_ASSETS_JS_DIR .'spectrum.js', array('jquery') ,false, false );
		wp_enqueue_script( 'font-farsi-admin-spectrum-js');

		
	}

	// Enqueue WP Head Style
	function enqueue_wp_style () {
		wp_enqueue_style( 'font-farsi-fonts', FONT_FARSI_ASSETS_URL .'fonts/fonts.css' , false, 'all' );

		if ( get_option('wp_font_main_website_en_num_to_fa') )
		{
			wp_enqueue_script( 'font-farsi-convert-en-num-to-fa', FONT_FARSI_ASSETS_JS_DIR . 'persianumber.js', array( 'jquery' ), '1', true );	
			# self::convert_en_num_to_fa();
		}
		
	}

	static function disable_gutenberg()
	{
		if ( get_option('wp_font_panel_disable_gutenberg') )
		{
			add_filter( 'use_block_editor_for_post', '__return_false' );
		}	
	}
		// Register Options

		function font_farsi_settings_register(){

		// Section Headings Settings 
			//H1
		register_setting( 'font_farsi_settings_group', 'h1_font' );
		register_setting( 'font_farsi_settings_group', 'h1_font_enable' );
		register_setting( 'font_farsi_settings_group', 'h1_font_size' );
		register_setting( 'font_farsi_settings_group', 'h1_font_unit' );
		register_setting( 'font_farsi_settings_group', 'h1_font_color' );
		register_setting( 'font_farsi_settings_group', 'h1_font_color_enable' );
		register_setting( 'font_farsi_settings_group', 'h1_font_line_height' );
		// Heading Font #1 Style Options 
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_margin_top_#1' );		
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_margin_bottom_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_margin_right_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_margin_left_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_padding_top_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_padding_bottom_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_padding_right_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_padding_left_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_top_color_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_top_style_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_top_width_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_bottom_color_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_bottom_style_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_bottom_width_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_right_color_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_right_style_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_right_width_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_left_color_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_left_style_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_left_width_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_radius_value_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_border_radius_value_unit_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_textalign_#1' );
		register_setting( 'font_farsi_settings_group', 'hfont_1_f_style_background_color_#1' );
			//H2
		register_setting( 'font_farsi_settings_group', 'h2_font' );
		register_setting( 'font_farsi_settings_group', 'h2_font_enable' );
		register_setting( 'font_farsi_settings_group', 'h2_font_size' );
		register_setting( 'font_farsi_settings_group', 'h2_font_unit' );
		register_setting( 'font_farsi_settings_group', 'h2_font_color' );
		register_setting( 'font_farsi_settings_group', 'h2_font_color_enable' );
		register_setting( 'font_farsi_settings_group', 'h2_font_line_height' );
		// Heading Font #2 Style Options 
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_margin_top_#2' );		
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_margin_bottom_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_margin_right_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_margin_left_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_padding_top_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_padding_bottom_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_padding_right_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_padding_left_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_top_color_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_top_style_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_top_width_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_bottom_color_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_bottom_style_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_bottom_width_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_right_color_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_right_style_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_right_width_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_left_color_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_left_style_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_left_width_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_radius_value_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_border_radius_value_unit_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_textalign_#2' );
		register_setting( 'font_farsi_settings_group', 'hfont_2_f_style_background_color_#2' );
			//H3
		register_setting( 'font_farsi_settings_group', 'h3_font' );
		register_setting( 'font_farsi_settings_group', 'h3_font_enable' );
		register_setting( 'font_farsi_settings_group', 'h3_font_size' );
		register_setting( 'font_farsi_settings_group', 'h3_font_color' );
		register_setting( 'font_farsi_settings_group', 'h3_font_unit' );
		register_setting( 'font_farsi_settings_group', 'h3_font_color_enable' );
		register_setting( 'font_farsi_settings_group', 'h3_font_line_height' );
		// Heading Font #3 Style Options 
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_margin_top_#3' );		
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_margin_bottom_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_margin_right_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_margin_left_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_padding_top_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_padding_bottom_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_padding_right_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_padding_left_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_top_color_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_top_style_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_top_width_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_bottom_color_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_bottom_style_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_bottom_width_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_right_color_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_right_style_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_right_width_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_left_color_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_left_style_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_left_width_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_radius_value_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_border_radius_value_unit_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_textalign_#3' );
		register_setting( 'font_farsi_settings_group', 'hfont_3_f_style_background_color_#3' );
			//H4
		register_setting( 'font_farsi_settings_group', 'h4_font' );
		register_setting( 'font_farsi_settings_group', 'h4_font_enable' );
		register_setting( 'font_farsi_settings_group', 'h4_font_size' );
		register_setting( 'font_farsi_settings_group', 'h4_font_unit' );
		register_setting( 'font_farsi_settings_group', 'h4_font_color' );
		register_setting( 'font_farsi_settings_group', 'h4_font_color_enable' );
		register_setting( 'font_farsi_settings_group', 'h4_font_line_height' );
		// Heading Font #4 Style Options 
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_margin_top_#4' );		
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_margin_bottom_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_margin_right_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_margin_left_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_padding_top_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_padding_bottom_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_padding_right_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_padding_left_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_top_color_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_top_style_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_top_width_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_bottom_color_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_bottom_style_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_bottom_width_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_right_color_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_right_style_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_right_width_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_left_color_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_left_style_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_left_width_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_radius_value_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_border_radius_value_unit_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_textalign_#4' );
		register_setting( 'font_farsi_settings_group', 'hfont_4_f_style_background_color_#4' );
			//H5
		register_setting( 'font_farsi_settings_group', 'h5_font' );
		register_setting( 'font_farsi_settings_group', 'h5_font_enable' );
		register_setting( 'font_farsi_settings_group', 'h5_font_size' );
		register_setting( 'font_farsi_settings_group', 'h5_font_unit' );
		register_setting( 'font_farsi_settings_group', 'h5_font_color' );
		register_setting( 'font_farsi_settings_group', 'h5_font_color_enable' );
		register_setting( 'font_farsi_settings_group', 'h5_font_line_height' );
		// Heading Font #5 Style Options 
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_margin_top_#5' );		
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_margin_bottom_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_margin_right_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_margin_left_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_padding_top_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_padding_bottom_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_padding_right_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_padding_left_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_top_color_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_top_style_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_top_width_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_bottom_color_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_bottom_style_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_bottom_width_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_right_color_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_right_style_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_right_width_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_left_color_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_left_style_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_left_width_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_radius_value_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_border_radius_value_unit_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_textalign_#5' );
		register_setting( 'font_farsi_settings_group', 'hfont_5_f_style_background_color_#5' );
			//H6
		register_setting( 'font_farsi_settings_group', 'h6_font' );
		register_setting( 'font_farsi_settings_group', 'h6_font_enable' );
		register_setting( 'font_farsi_settings_group', 'h6_font_size' );
		register_setting( 'font_farsi_settings_group', 'h6_font_unit' );
		register_setting( 'font_farsi_settings_group', 'h6_font_color' );
		register_setting( 'font_farsi_settings_group', 'h6_font_color_enable' );
		register_setting( 'font_farsi_settings_group', 'h6_font_line_height' );
		// Heading Font #6 Style Options 
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_margin_top_#6' );		
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_margin_bottom_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_margin_right_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_margin_left_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_padding_top_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_padding_bottom_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_padding_right_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_padding_left_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_top_color_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_top_style_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_top_width_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_bottom_color_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_bottom_style_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_bottom_width_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_right_color_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_right_style_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_right_width_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_left_color_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_left_style_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_left_width_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_radius_value_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_border_radius_value_unit_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_textalign_#6' );
		register_setting( 'font_farsi_settings_group', 'hfont_6_f_style_background_color_#6' );

		// Section wp admin font Settings
		register_setting( 'font_farsi_settings_group', 'wp_font' );
		register_setting( 'font_farsi_settings_group', 'wp_font_panel_color' );
		register_setting( 'font_farsi_settings_group', 'wp_font_panel_color_bg_active' );
		register_setting( 'font_farsi_settings_group', 'wp_font_panel_disable_gutenberg' );


		// Section Main Website Font Settings
		register_setting( 'font_farsi_settings_group', 'wp_font_main_website' );
		register_setting( 'font_farsi_settings_group', 'wp_font_main_website_enable' );
		register_setting( 'font_farsi_settings_group', 'wp_font_main_website_amp_enable' );
		register_setting( 'font_farsi_settings_group', 'wp_font_main_website_en_num_to_fa' );

		// Section Custom Font Settings

		// Custom Font #1
		register_setting( 'custom_font_settings_group', 'custom_font_enable_#1' );		
		register_setting( 'custom_font_settings_group', 'custom_font_tag_name_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_type_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_path_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_ffamily_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_unit_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstretch_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstyle_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_fweight_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_fline_height_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_fletter_spacing_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_fword_spacing_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_fcolor_#1' );
		// Custom Font #1 Style Options 
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_top_#1' );		
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_bottom_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_right_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_left_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_top_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_bottom_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_right_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_left_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_color_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_style_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_width_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_color_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_style_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_width_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_color_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_style_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_width_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_color_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_style_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_width_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_unit_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_textalign_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_background_color_#1' );

		// Custom Font #2
		register_setting( 'custom_font_settings_group', 'custom_font_enable_#2' );		
		register_setting( 'custom_font_settings_group', 'custom_font_tag_name_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_type_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_path_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_ffamily_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_unit_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstretch_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstyle_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_fweight_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_fline_height_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_fletter_spacing_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_fword_spacing_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_fcolor_#2' );
		// Custom Font #2 Style Options 
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_top_#2' );		
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_bottom_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_right_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_left_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_top_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_bottom_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_right_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_left_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_color_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_style_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_width_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_color_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_style_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_width_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_color_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_style_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_width_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_color_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_style_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_width_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_unit_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_textalign_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_background_color_#2' );


		// Custom Font #3
		register_setting( 'custom_font_settings_group', 'custom_font_enable_#3' );		
		register_setting( 'custom_font_settings_group', 'custom_font_tag_name_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_type_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_path_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_ffamily_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_unit_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstretch_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstyle_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_fweight_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_fline_height_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_fletter_spacing_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_fword_spacing_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_fcolor_#3' );
		// Custom Font #3 Style Options 
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_top_#3' );		
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_bottom_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_right_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_left_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_top_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_bottom_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_right_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_left_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_color_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_style_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_width_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_color_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_style_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_width_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_color_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_style_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_width_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_color_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_style_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_width_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_unit_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_textalign_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_background_color_#3' );


		// Custom Font #4
		register_setting( 'custom_font_settings_group', 'custom_font_enable_#4' );		
		register_setting( 'custom_font_settings_group', 'custom_font_tag_name_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_type_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_path_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_ffamily_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_unit_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstretch_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstyle_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_fweight_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_fline_height_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_fletter_spacing_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_fword_spacing_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_fcolor_#4' );
		// Custom Font #4 Style Options 
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_top_#4' );		
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_bottom_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_right_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_left_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_top_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_bottom_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_right_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_left_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_color_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_style_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_width_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_color_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_style_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_width_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_color_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_style_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_width_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_color_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_style_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_width_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_unit_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_textalign_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_background_color_#4' );


		// Custom Font #5
		register_setting( 'custom_font_settings_group', 'custom_font_enable_#5' );		
		register_setting( 'custom_font_settings_group', 'custom_font_tag_name_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_type_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_path_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_ffamily_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_unit_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstretch_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstyle_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_fweight_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_fline_height_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_fletter_spacing_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_fword_spacing_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_fcolor_#5' );
		// Custom Font #5 Style Options 
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_top_#5' );		
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_bottom_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_right_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_left_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_top_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_bottom_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_right_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_left_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_color_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_style_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_width_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_color_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_style_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_width_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_color_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_style_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_width_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_color_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_style_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_width_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_unit_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_textalign_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_background_color_#5' );


		// Custom Font #6
		register_setting( 'custom_font_settings_group', 'custom_font_enable_#6' );		
		register_setting( 'custom_font_settings_group', 'custom_font_tag_name_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_type_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_path_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_ffamily_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_unit_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstretch_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstyle_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_fweight_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_fline_height_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_fletter_spacing_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_fword_spacing_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_fcolor_#6' );
		// Custom Font #6 Style Options 
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_top_#6' );		
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_bottom_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_right_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_left_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_top_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_bottom_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_right_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_left_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_color_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_style_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_width_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_color_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_style_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_width_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_color_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_style_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_width_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_color_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_style_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_width_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_unit_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_textalign_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_background_color_#6' );


		// Custom Font #7
		register_setting( 'custom_font_settings_group', 'custom_font_enable_#7' );		
		register_setting( 'custom_font_settings_group', 'custom_font_tag_name_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_type_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_path_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_ffamily_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_unit_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstretch_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstyle_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_fweight_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_fline_height_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_fletter_spacing_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_fword_spacing_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_fcolor_#7' );
		// Custom Font #7 Style Options 
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_top_#7' );		
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_bottom_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_right_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_left_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_top_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_bottom_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_right_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_left_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_color_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_style_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_width_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_color_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_style_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_width_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_color_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_style_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_width_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_color_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_style_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_width_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_unit_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_textalign_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_background_color_#7' );


		// Custom Font #8
		register_setting( 'custom_font_settings_group', 'custom_font_enable_#8' );		
		register_setting( 'custom_font_settings_group', 'custom_font_tag_name_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_type_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_path_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_ffamily_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_unit_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstretch_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstyle_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_fweight_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_fline_height_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_fletter_spacing_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_fword_spacing_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_fcolor_#8' );
		// Custom Font #8 Style Options 
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_top_#8' );		
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_bottom_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_right_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_left_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_top_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_bottom_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_right_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_left_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_color_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_style_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_width_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_color_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_style_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_width_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_color_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_style_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_width_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_color_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_style_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_width_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_unit_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_textalign_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_background_color_#8' );


		// Custom Font #9
		register_setting( 'custom_font_settings_group', 'custom_font_enable_#9' );		
		register_setting( 'custom_font_settings_group', 'custom_font_tag_name_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_type_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_path_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_ffamily_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_unit_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstretch_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstyle_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_fweight_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_fline_height_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_fletter_spacing_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_fword_spacing_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_fcolor_#9' );
		// Custom Font #9 Style Options 
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_top_#9' );		
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_bottom_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_right_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_left_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_top_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_bottom_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_right_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_left_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_color_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_style_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_width_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_color_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_style_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_width_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_color_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_style_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_width_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_color_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_style_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_width_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_unit_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_textalign_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_background_color_#9' );


		// Custom Font #10
		register_setting( 'custom_font_settings_group', 'custom_font_enable_#10' );		
		register_setting( 'custom_font_settings_group', 'custom_font_tag_name_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_type_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_path_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_ffamily_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_fsize_unit_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstretch_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_fstyle_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_fweight_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_fline_height_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_fletter_spacing_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_fword_spacing_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_fcolor_#10' );
		// Custom Font #10 Style Options 
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_top_#10' );		
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_bottom_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_right_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_margin_left_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_top_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_bottom_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_right_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_padding_left_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_color_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_style_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_top_width_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_color_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_style_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_bottom_width_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_color_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_style_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_right_width_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_color_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_style_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_left_width_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_border_radius_value_unit_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_textalign_#10' );
		register_setting( 'custom_font_settings_group', 'custom_font_f_style_background_color_#10' );


		// Custom Font: Note Input
		register_setting( 'custom_font_settings_group', 'custom_font_note_#1' );
		register_setting( 'custom_font_settings_group', 'custom_font_note_#2' );
		register_setting( 'custom_font_settings_group', 'custom_font_note_#3' );
		register_setting( 'custom_font_settings_group', 'custom_font_note_#4' );
		register_setting( 'custom_font_settings_group', 'custom_font_note_#5' );
		register_setting( 'custom_font_settings_group', 'custom_font_note_#6' );
		register_setting( 'custom_font_settings_group', 'custom_font_note_#7' );
		register_setting( 'custom_font_settings_group', 'custom_font_note_#8' );
		register_setting( 'custom_font_settings_group', 'custom_font_note_#9' );
		register_setting( 'custom_font_settings_group', 'custom_font_note_#10' );

		// END: Section Custom Font Settings

		// Section Custom Css Settings
		register_setting( 'custom_css_settings_group', 'c_css_textarea' );

		// END Sections Settings

		/*  Write All Sections */

		//START Sections

		// Section font_farsi_settings_section 
		$sid = "font_farsi_settings_section";
		$stitle = esc_html__('Heading Fonts' , 'font-farsi');
		add_settings_section( $sid, $stitle, null, $this->menu_slug );
		
		// Section wp_admin_font
		$sid_2 = "wp_admin_font";
		$stitle_2 = esc_html__("Wordpress Panel Font", 'font-farsi');
		add_settings_section( $sid_2, $stitle_2, null, $this->menu_slug );
	

		// Section Custom Font
		$sid_3 = "custome_font";
		$stitle_3 = esc_html__("Custom Font", 'font-farsi');
		add_settings_section( $sid_3, $stitle_3,[$this, 'font_farsi_custom_font_section_cb'] , 'font-farsi-custom-font' );		

		// Section Custom Css
		$sid_4 = "custom_css";
		$stitle_4 = esc_html__("Custom Css", 'font-farsi');
		add_settings_section( $sid_4, $stitle_4, [$this, 'font_farsi_custom_css_section_cb'], 'font-farsi-custom-css' );

		
		// Section main website font
		$sid_5 = "main_website_font";
		$stitle_5 = esc_html__("Main Website Font", 'font-farsi');
		add_settings_section( $sid_5, $stitle_5, [$this, 'font_farsi_main_website_font_section_cb'],$this->menu_slug );	
		
		// Section Help
		$sid_6 = "font_farsi_help";
		$stitle_6 = esc_html__("Help", 'font-farsi');
		add_settings_section( $sid_6, $stitle_6, NULL , 'font-farsi-help' );


		// Write All Fields

		// Field H1
		$fid_h1 = "font_farsi_settings_section_h1_font";
		$ftitle_h1= esc_html__("H1 Font", 'font-farsi');
		add_settings_field( $fid_h1, esc_html__("H1 Font",'font-farsi'), [$this ,'font_farsi_settings_section_h1_font_cb'], $this->menu_slug , $sid);

		// Field H2
		$fid_h2 = "font_farsi_settings_section_h2_font";
		$ftitle_h2= esc_html__("H2 Font", 'font-farsi');
		add_settings_field( $fid_h2, $ftitle_h2, [$this ,'font_farsi_settings_section_h2_font_cb'], $this->menu_slug , $sid);

		// Field H3
		$fid_h3 = "font_farsi_settings_section_h3_font";
		$ftitle_h3= esc_html__("H3 Font", 'font-farsi');
		add_settings_field( $fid_h3, $ftitle_h3, [$this ,'font_farsi_settings_section_h3_font_cb'], $this->menu_slug , $sid);

		// Field H4
		$fid_h4 = "font_farsi_settings_section_h4_font";
		$ftitle_h4= esc_html__("H4 Font", 'font-farsi');
		add_settings_field( $fid_h4, $ftitle_h4, [$this ,'font_farsi_settings_section_h4_font_cb'], $this->menu_slug , $sid);

		// Field H5
		$fid_h5 = "font_farsi_settings_section_h5_font";
		$ftitle_h5= esc_html__("H5 Font", 'font-farsi');
		add_settings_field( $fid_h5, $ftitle_h5, [$this ,'font_farsi_settings_section_h5_font_cb'], $this->menu_slug , $sid);

		// Field H6
		$fid_h6 = "font_farsi_settings_section_h6_font";
		$ftitle_h6= esc_html__("H6 Font", 'font-farsi');
		add_settings_field( $fid_h6, $ftitle_h6, [$this ,'font_farsi_settings_section_h6_font_cb'], $this->menu_slug , $sid);

		// Field wp admin font
		$fid_wp_font = "wp_admin_font_field";
		$ftitle_wp_font = esc_html__("Main Wordpress Panel Font", 'font-farsi');
		add_settings_field( $fid_wp_font, $ftitle_wp_font, [$this,'font_farsi_settings_section_wp_font_cb'], $this->menu_slug, $sid_2);

		// Field wp disable gutenberg
		$fid_wp_disable_gutenberg = "wp_disable_gutenberg_field";
		$ftitle_wp_disable_gutenberg = esc_html__("Disable Gutenberg", 'font-farsi');
		add_settings_field( $fid_wp_disable_gutenberg, $ftitle_wp_disable_gutenberg, [$this,'disable_gutenberg_cb'], $this->menu_slug, $sid_2);

		// Field main website font
		$fid_m_w_font = "wp_site_font_field";
		$ftitle_m_w_font = esc_html__("Main Website Panel Font", 'font-farsi');
		add_settings_field( $fid_m_w_font, $ftitle_m_w_font, [$this,'font_farsi_main_website_font_field_cb'], $this->menu_slug, $sid_5);

		// Field En Number To Fa
		$fid_en_num_to_fa = "wp_main_en_num_to_fa_filed";
		$ftitle_en_num_to_fa = esc_html__("Convert En Number To Fa Number", 'font-farsi');
		add_settings_field( $fid_en_num_to_fa, $ftitle_en_num_to_fa, [$this,'font_farsi_main_website_en_num_to_fa_field_cb'], $this->menu_slug, $sid_5);



		// START: Custom Font Field
		
		// Field custom font #1
		$fid_custom_font_1 = "font_farsi_custom_font_1";
		$ftitle_custom_font_1 = esc_html__("Custom Font #1", 'font-farsi');

		add_settings_field(

		 $fid_custom_font_1,
		 $ftitle_custom_font_1,
		 [$this,'font_farsi_settings_section_custom_font_1_cb'],
		 'font-farsi-custom-font',
		 $sid_3

		);

		// Field custom font #2
		$fid_custom_font_2 = "font_farsi_custom_font_2";
		$ftitle_custom_font_2 = esc_html__("Custom Font #2", 'font-farsi');

		add_settings_field(

		 $fid_custom_font_2,
		 $ftitle_custom_font_2,
		 [$this,'font_farsi_settings_section_custom_font_2_cb'],
		 'font-farsi-custom-font',
		 $sid_3

		);

		// Field custom font #3
		$fid_custom_font_3 = "font_farsi_custom_font_3";
		$ftitle_custom_font_3 = esc_html__("Custom Font #3", 'font-farsi');

		add_settings_field(

		 $fid_custom_font_3,
		 $ftitle_custom_font_3,
		 [$this,'font_farsi_settings_section_custom_font_3_cb'],
		 'font-farsi-custom-font',
		 $sid_3

		);

		// Field custom font #4
		$fid_custom_font_4 = "font_farsi_custom_font_4";
		$ftitle_custom_font_4 = esc_html__("Custom Font #4", 'font-farsi');

		add_settings_field(

		 $fid_custom_font_4,
		 $ftitle_custom_font_4,
		 [$this,'font_farsi_settings_section_custom_font_4_cb'],
		 'font-farsi-custom-font',
		 $sid_3
		);

		// Field custom font #5
		$fid_custom_font_5 = "font_farsi_custom_font_5";
		$ftitle_custom_font_5 = esc_html__("Custom Font #5", 'font-farsi');

		add_settings_field(

		 $fid_custom_font_5,
		 $ftitle_custom_font_5,
		 [$this,'font_farsi_settings_section_custom_font_5_cb'],
		 'font-farsi-custom-font',
		 $sid_3

		);

		// Field custom font #6
		$fid_custom_font_6 = "font_farsi_custom_font_6";
		$ftitle_custom_font_6 = esc_html__("Custom Font #6", 'font-farsi');

		add_settings_field(

		 $fid_custom_font_6,
		 $ftitle_custom_font_6,
		 [$this,'font_farsi_settings_section_custom_font_6_cb'],
		 'font-farsi-custom-font',
		 $sid_3

		);

		// Field custom font #7
		$fid_custom_font_7 = "font_farsi_custom_font_7";
		$ftitle_custom_font_7 = esc_html__("Custom Font #7", 'font-farsi');

		add_settings_field(

		 $fid_custom_font_7,
		 $ftitle_custom_font_7,
		 [$this,'font_farsi_settings_section_custom_font_7_cb'],
		 'font-farsi-custom-font',
		 $sid_3

		);

		// Field custom font #8
		$fid_custom_font_8 = "font_farsi_custom_font_8";
		$ftitle_custom_font_8 = esc_html__("Custom Font #8", 'font-farsi');

		add_settings_field(

		 $fid_custom_font_8,
		 $ftitle_custom_font_8,
		 [$this,'font_farsi_settings_section_custom_font_8_cb'],
		 'font-farsi-custom-font',
		 $sid_3

		);

		// Field custom font #9
		$fid_custom_font_9 = "font_farsi_custom_font_9";
		$ftitle_custom_font_9 = esc_html__("Custom Font #9", 'font-farsi');

		add_settings_field(

		 $fid_custom_font_9,
		 $ftitle_custom_font_9,
		 [$this,'font_farsi_settings_section_custom_font_9_cb'],
		 'font-farsi-custom-font',
		 $sid_3

		);

		// Field custom font #10
		$fid_custom_font_10 = "font_farsi_custom_font_10";
		$ftitle_custom_font_10 = esc_html__("Custom Font #10", 'font-farsi');

		add_settings_field(

		 $fid_custom_font_10,
		 $ftitle_custom_font_10,
		 [$this,'font_farsi_settings_section_custom_font_10_cb'],
		 'font-farsi-custom-font',
		 $sid_3

		);

		// End font_farsi_settings_register
	}

	// START: Font farsi Custom Font Field Call Back

	function font_farsi_settings_section_custom_font_1_cb()
	{
		$custom_font_panel_1 = new class_custom_font_panel();
		$custom_font_panel_1->font_farsi_settings_section_custom_font_1_cb();
	}

	function font_farsi_settings_section_custom_font_2_cb()
	{
		$custom_font_panel_2 = new class_custom_font_panel();
		$custom_font_panel_2-> font_farsi_settings_section_custom_font_2_cb();
	}

	function font_farsi_settings_section_custom_font_3_cb()
	{

		$custom_font_panel_3 = new class_custom_font_panel();
		$custom_font_panel_3-> font_farsi_settings_section_custom_font_3_cb();

	}

	function font_farsi_settings_section_custom_font_4_cb()
	{

		$custom_font_panel_4 = new class_custom_font_panel();
		$custom_font_panel_4-> font_farsi_settings_section_custom_font_4_cb();

	}

	function font_farsi_settings_section_custom_font_5_cb()
	{

		$custom_font_panel_5 = new class_custom_font_panel();
		$custom_font_panel_5-> font_farsi_settings_section_custom_font_5_cb();

	}

	function font_farsi_settings_section_custom_font_6_cb()
	{

		$custom_font_panel_6 = new class_custom_font_panel();
		$custom_font_panel_6-> font_farsi_settings_section_custom_font_6_cb();

	}

	function font_farsi_settings_section_custom_font_7_cb()
	{

		$custom_font_panel_7 = new class_custom_font_panel();
		$custom_font_panel_7-> font_farsi_settings_section_custom_font_7_cb();

	}

	function font_farsi_settings_section_custom_font_8_cb()
	{

		$custom_font_panel_8 = new class_custom_font_panel();
		$custom_font_panel_8-> font_farsi_settings_section_custom_font_8_cb();

	}

	function font_farsi_settings_section_custom_font_9_cb()
	{

		$custom_font_panel_9 = new class_custom_font_panel();
		$custom_font_panel_9-> font_farsi_settings_section_custom_font_9_cb();

	}

	function font_farsi_settings_section_custom_font_10_cb()
	{

		$custom_font_panel_10 = new class_custom_font_panel();
		$custom_font_panel_10-> font_farsi_settings_section_custom_font_10_cb();

	}

	// END: Font farsi Custom Font Field Call Back

	// font_farsi_custom_css_section_cb
	function font_farsi_custom_css_section_cb()
	{
		$custom_css_panel = new Class_Custom_Css_Panel();
		$custom_css_panel->font_farsi_custom_css_section_cb();
	}

	// Custom Font Section CallBack

	function font_farsi_custom_font_section_cb()
	{
		echo '
				<p class="notice notice-success notice-large"> ' . 

				esc_html__("In this section, you can easily apply your custom font to the desired tag." ,'font-farsi')
				. '
			 ';
	}

	// font_farsi_settings_section_cb
	function font_farsi_settings_section_cb ()
	{

		echo "section1 Call-Back";

	}

	function font_farsi_main_website_font_section_cb ()
	{
		return '';
	}

	// font_farsi_settings_section_field_cb
	function font_farsi_settings_section_h1_font_cb ()
	{
		$show_h1font_cb = new ClassH1Font ();
		$show_h1font_cb-> H1Font_cb();
	}

	function font_farsi_settings_section_h2_font_cb ()
	{
		
		$show_h2font_cb = new ClassH2Font ();
		$show_h2font_cb-> H2Font_cb();
	}

	function font_farsi_settings_section_h3_font_cb ()
	{
		$show_h3font_cb = new ClassH3Font ();
		$show_h3font_cb-> H3Font_cb();
	}

	function font_farsi_settings_section_h4_font_cb ()
	{
		$show_h4font_cb = new ClassH4Font ();
		$show_h4font_cb-> H4Font_cb();	
	}

	function font_farsi_settings_section_h5_font_cb ()
	{
		$show_h5font_cb = new ClassH5Font ();
		$show_h5font_cb-> H5Font_cb();		
	}

	function font_farsi_settings_section_h6_font_cb ()
	{
		$show_h6font_cb = new ClassH6Font ();
		$show_h6font_cb-> H6Font_cb();
	}

	function font_farsi_settings_section_wp_font_cb ()
	{
		$show_wpfont_cb = new ClassWpFont ();
		$show_wpfont_cb-> wpfont_setting();
	}
	
	function font_farsi_main_website_font_field_cb ()
	{
		$show_sitefont_cb = new ClassSiteFont ();
		$show_sitefont_cb-> sitefont_setting();
	}

	function disable_gutenberg_cb ()
	{
		?>
			<label for="wp_font_panel_disable_gutenberg">
				<input type="checkbox" id="wp_font_panel_disable_gutenberg" name="wp_font_panel_disable_gutenberg" value="enable" <?php checked( get_option('wp_font_panel_disable_gutenberg'), 'enable', true );?> />
				<span class="margin-3">
					<?php echo esc_html__("Use Default Wordpress Edittor, Disable Gutenberg", 'font-farsi'); ?>	
				</span>
			</label>

		<?php
	}

	// Convert En Number To Farsi
	public static function convert_en_num_to_fa ()
	{
		if ( get_option('wp_font_main_website_en_num_to_fa') )
		{
		?>
			<script type="text/javascript">

				jQuery(document).ready(function(){jQuery('body').persiaNumber();});

			</script>

		<?php
		}
	}

	function font_farsi_main_website_en_num_to_fa_field_cb ()
	{
		?>
		<label for="wp_font_main_website_en_num_to_fa">
			<input type="checkbox" id="wp_font_main_website_en_num_to_fa" name="wp_font_main_website_en_num_to_fa" value="enable" <?php checked(get_option('wp_font_main_website_en_num_to_fa'),'enable',true) ;?> />
			<span class="margin-3">
				<?php echo esc_html__("Convert English Number To Farsi Number", 'font-farsi'); ?>
			</span>
		</label>
		<?php
	}

	// font_farsi_admin_menu_callback
	function font_farsi_admin_menu_callback() {
	?>

<div class="wrap">
<div class="wrap-1">
<div id="plugin-title">
<?php echo esc_html__("Font Farsi Version", 'font-farsi'); ?> <?php echo '<strong>'.  FONT_FARSI_VERSION . '</strong>'; ?>
<hr />
</div>
<div id="option-wrap-xx">
<?php
// Select Font Function
$this->select_font();
?>
</div>
</div>

<?php
// End font_farsi_admin_panel_callback
}

function select_font() {
?>
<form class="font-farsi-form" method="post" action="options.php"> 

   <?php settings_errors();?>
   <?php  do_settings_sections( $this->menu_slug);?>
   <?php  settings_fields( 'font_farsi_settings_group' );?>
   <?php submit_button(); ?>

</form>
<?php
}
	
	// Enable AMP Font
	
	public function amp_mode_font() 
	{
		$is_font_amp_mode_enabled = get_option('wp_font_main_website_amp_enable');

		if ($is_font_amp_mode_enabled == 'enable' )
		{
		?>
		<style amp-custom>

			p, ul li, footer, header, nav, span, div, b, strong, a, address, textarea, input, table tbody, table thead, table tfooter, q, button, blockquote, caption, form
				{
				  font-family:ETmodules, FontAwesome, Icons, typicons, entypo, linecons, "Material Icons", "Mono Social Icons Font", "<?php echo get_option( 'wp_font_main_website' ); ?>" ;
				}
				

		</style>
		<?php
		}
	}
	
   // Function For Check Options

 	 function check_option ($css_value , $option_name , $var)
 	 {
 	 	if ($var !='') {
 	 		$var_unit = $var;
 	 	}
 	 	else
 	 	{
 	 		$var_unit = '';
 	 	}

	  	$option = get_option($option_name);
	  	$sep = ':';
	  	$sep2 = ';';
	  	$important = ' !important';

	  	if ( get_option($option_name) != '' )
	  	{
			 echo $css_value . $sep . $option . $var_unit . $important . $sep2;
	  	}
	  	else {
	  		return false;
	  	}
	  	// End Function
   }
   		// Plugin Trademark Text
    function font_farsi_trademark() {

    	echo '<!-- This Site Used Font Farsi Version: ' . FONT_FARSI_VERSION . ' ;: Plugin Developer: https://Persian-vc.com :;-->
    	';

    }

	public function wp_head_output(){

		$this->font_farsi_trademark();

			# Check Heading Enable	 
		$chk_h1_enable = get_option('h1_font_enable');
		$chk_h2_enable = get_option('h2_font_enable');
		$chk_h3_enable = get_option('h3_font_enable');
		$chk_h4_enable = get_option('h4_font_enable');
		$chk_h5_enable = get_option('h5_font_enable');
		$chk_h6_enable = get_option('h6_font_enable');
		$wp_font_main_website_enable = get_option('wp_font_main_website_enable');

		if ( $chk_h1_enable =='Enable' || $chk_h2_enable =='Enable' || $chk_h3_enable =='Enable' || $chk_h4_enable =='Enable' || $chk_h5_enable =='Enable' || $chk_h6_enable =='Enable' || $wp_font_main_website_enable == 'Enable')
		{
			if (is_user_logged_in()){
				echo '
					<style type="text/css">
					div#wpadminbar * span::before{font-family:dashicons, ETmodules, FontAwesome, Icons, typicons, entypo, linecons, "Material Icons", "Mono Social Icons Font"}
					div#wpadminbar {font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue",sans-serif}
				</style>';
			}
			
			echo "<style>";

		# Heading 1 Is Enable
		if ( $chk_h1_enable == 'Enable' ) 
		{ ?>
		div h1, h1{font-family:"<?php echo get_option('h1_font');?>" !important;font-size:<?php echo get_option('h1_font_size'); echo get_option('h1_font_unit');?> !important;
		<?php
		if (get_option('h1_font_color_enable') == 'Yes' ) 
		{
			echo 'color:#' . get_option('h1_font_color') . ' !important;';
		 }
		 	// New Style For Option Check
		 $this->check_option ('line-height','h1_font_line_height', '%');
		 //border-top
		 $this->check_option ('border-top-color','hfont_1_f_style_border_top_color_#1', null);
		 $this->check_option ('border-top-style','hfont_1_f_style_border_top_style_#1', null);
		 $this->check_option ('border-top-width','hfont_1_f_style_border_top_width_#1', 'px');
		 //border-bottom
		 $this->check_option ('border-bottom-color','hfont_1_f_style_border_bottom_color_#1', null);
		 $this->check_option ('border-bottom-style','hfont_1_f_style_border_bottom_style_#1', null);
		 $this->check_option ('border-bottom-width','hfont_1_f_style_border_bottom_width_#1', 'px');
		 //border-right
		 $this->check_option ('border-right-color','hfont_1_f_style_border_right_color_#1', null);
		 $this->check_option ('border-right-style','hfont_1_f_style_border_right_style_#1', null);
		 $this->check_option ('border-right-width','hfont_1_f_style_border_right_width_#1', 'px');
		 //border-left
		 $this->check_option ('border-left-color','hfont_1_f_style_border_left_color_#1', null);
		 $this->check_option ('border-left-style','hfont_1_f_style_border_left_style_#1', null);
		 $this->check_option ('border-left-width','hfont_1_f_style_border_left_width_#1', 'px');
		 //border-radius
		 if (get_option('hfont_1_f_style_border_radius_value_#1') != '') {
		 	echo 'border-radius:' . get_option('hfont_1_f_style_border_radius_value_#1') . get_option('hfont_1_f_style_border_radius_value_unit_#1') . ' !important;';
		 }
		 //padding
		 $this->check_option ('padding-top','hfont_1_f_style_padding_top_#1','px');
		 $this->check_option ('padding-bottom','hfont_1_f_style_padding_bottom_#1','px');
		 $this->check_option ('padding-right','hfont_1_f_style_padding_right_#1','px');
		 $this->check_option ('padding-left','hfont_1_f_style_padding_left_#1','px');
		 //margin
		 $this->check_option ('margin-top','hfont_1_f_style_margin_top_#1','px');
		 $this->check_option ('margin-bottom','hfont_1_f_style_margin_bottom_#1','px');
		 $this->check_option ('margin-right','hfont_1_f_style_margin_right_#1','px');
		 $this->check_option ('margin-left','hfont_1_f_style_margin_left_#1','px');		 
		 //background
		 $this->check_option ('background-color','hfont_1_f_style_background_color_#1', null);
		 //text-align
		 $this->check_option ('text-align','hfont_1_f_style_textalign_#1', null);

		 //End h1 codes
		 echo '}';
		}

		# Heading 2 Is Enable
		if ( $chk_h2_enable == 'Enable' ) 
		{ ?>
		div h2, h2{font-family:"<?php echo get_option( 'h2_font' ); ?>" !important;font-size:<?php echo get_option('h2_font_size');echo get_option('h2_font_unit');?> !important; 
		<?php

		if (get_option('h2_font_color_enable') == 'Yes' ) 
		{
			echo 'color:#' . get_option('h2_font_color') . ' !important;';
		 }	

		 // New Style For Option Check
		 $this->check_option ('line-height','h2_font_line_height', '%');
		 //border-top
		 $this->check_option ('border-top-color','hfont_2_f_style_border_top_color_#2', null);
		 $this->check_option ('border-top-style','hfont_2_f_style_border_top_style_#2', null);
		 $this->check_option ('border-top-width','hfont_2_f_style_border_top_width_#2', 'px');
		 //border-bottom
		 $this->check_option ('border-bottom-color','hfont_2_f_style_border_bottom_color_#2', null);
		 $this->check_option ('border-bottom-style','hfont_2_f_style_border_bottom_style_#2', null);
		 $this->check_option ('border-bottom-width','hfont_2_f_style_border_bottom_width_#2', 'px');
		 //border-right
		 $this->check_option ('border-right-color','hfont_2_f_style_border_right_color_#2', null);
		 $this->check_option ('border-right-style','hfont_2_f_style_border_right_style_#2', null);
		 $this->check_option ('border-right-width','hfont_2_f_style_border_right_width_#2', 'px');
		 //border-left
		 $this->check_option ('border-left-color','hfont_2_f_style_border_left_color_#2', null);
		 $this->check_option ('border-left-style','hfont_2_f_style_border_left_style_#2', null);
		 $this->check_option ('border-left-width','hfont_2_f_style_border_left_width_#2', 'px');
		 //border-radius
		 if (get_option('hfont_2_f_style_border_radius_value_#2') != '') {
		 	echo 'border-radius:' . get_option('hfont_2_f_style_border_radius_value_#2') . get_option('hfont_2_f_style_border_radius_value_unit_#2') . ' !important;';
		 }
		 //padding
		 $this->check_option ('padding-top','hfont_2_f_style_padding_top_#2','px');
		 $this->check_option ('padding-bottom','hfont_2_f_style_padding_bottom_#2','px');
		 $this->check_option ('padding-right','hfont_2_f_style_padding_right_#2','px');
		 $this->check_option ('padding-left','hfont_2_f_style_padding_left_#2','px');
		 //margin
		 $this->check_option ('margin-top','hfont_2_f_style_margin_top_#2','px');
		 $this->check_option ('margin-bottom','hfont_2_f_style_margin_bottom_#2','px');
		 $this->check_option ('margin-right','hfont_2_f_style_margin_right_#2','px');
		 $this->check_option ('margin-left','hfont_2_f_style_margin_left_#2','px');		 
		 //background
		 $this->check_option ('background-color','hfont_2_f_style_background_color_#2', null);
		 //text-align
		 $this->check_option ('text-align','hfont_2_f_style_textalign_#2', null);

		 //End h2 codes
		 echo '}';
		}

		# Heading 3 Is Enable
		if ( $chk_h3_enable == 'Enable' ) 
		{ ?>
		div h3, h3{font-family:"<?php echo get_option( 'h3_font' ); ?>" !important;font-size:<?php echo get_option('h3_font_size');echo get_option('h3_font_unit');?> !important; 
		<?php 
		if (get_option('h3_font_color_enable') == 'Yes' ) 
		{
			echo 'color:#' . get_option('h3_font_color') . ' !important;';
		 }	
		 // New Style For Option Check
		 $this->check_option ('line-height','h3_font_line_height', '%');
		 //border-top
		 $this->check_option ('border-top-color','hfont_3_f_style_border_top_color_#3', null);
		 $this->check_option ('border-top-style','hfont_3_f_style_border_top_style_#3', null);
		 $this->check_option ('border-top-width','hfont_3_f_style_border_top_width_#3', 'px');
		 //border-bottom
		 $this->check_option ('border-bottom-color','hfont_3_f_style_border_bottom_color_#3', null);
		 $this->check_option ('border-bottom-style','hfont_3_f_style_border_bottom_style_#3', null);
		 $this->check_option ('border-bottom-width','hfont_3_f_style_border_bottom_width_#3', 'px');
		 //border-right
		 $this->check_option ('border-right-color','hfont_3_f_style_border_right_color_#3', null);
		 $this->check_option ('border-right-style','hfont_3_f_style_border_right_style_#3', null);
		 $this->check_option ('border-right-width','hfont_3_f_style_border_right_width_#3', 'px');
		 //border-left
		 $this->check_option ('border-left-color','hfont_3_f_style_border_left_color_#3', null);
		 $this->check_option ('border-left-style','hfont_3_f_style_border_left_style_#3', null);
		 $this->check_option ('border-left-width','hfont_3_f_style_border_left_width_#3', 'px');
		 //border-radius
		 if (get_option('hfont_3_f_style_border_radius_value_#3') != '') {
		 	echo 'border-radius:' . get_option('hfont_3_f_style_border_radius_value_#3') . get_option('hfont_3_f_style_border_radius_value_unit_#3') . ' !important;';
		 }
		 //padding
		 $this->check_option ('padding-top','hfont_3_f_style_padding_top_#3','px');
		 $this->check_option ('padding-bottom','hfont_3_f_style_padding_bottom_#3','px');
		 $this->check_option ('padding-right','hfont_3_f_style_padding_right_#3','px');
		 $this->check_option ('padding-left','hfont_3_f_style_padding_left_#3','px');
		 //margin
		 $this->check_option ('margin-top','hfont_3_f_style_margin_top_#3','px');
		 $this->check_option ('margin-bottom','hfont_3_f_style_margin_bottom_#3','px');
		 $this->check_option ('margin-right','hfont_3_f_style_margin_right_#3','px');
		 $this->check_option ('margin-left','hfont_3_f_style_margin_left_#3','px');		 
		 //background
		 $this->check_option ('background-color','hfont_3_f_style_background_color_#3', null);
		 //text-align
		 $this->check_option ('text-align','hfont_3_f_style_textalign_#3', null);

		 //End h3 codes
		 echo '}';
		}

		# Heading 4 Is Enable
		if ( $chk_h4_enable == 'Enable' ) 
		{ ?>
		div h4, h4{font-family:"<?php echo get_option( 'h4_font' ); ?>" !important;font-size:<?php echo get_option('h4_font_size');echo get_option('h4_font_unit');?> !important; 
		<?php 
		if (get_option('h4_font_color_enable') == 'Yes' ) 
		{
			echo 'color:#' . get_option('h4_font_color') . ' !important;';
		 }	
		 		 // New Style For Option Check
		 $this->check_option ('line-height','h4_font_line_height', '%');
		 //border-top
		 $this->check_option ('border-top-color','hfont_4_f_style_border_top_color_#4', null);
		 $this->check_option ('border-top-style','hfont_4_f_style_border_top_style_#4', null);
		 $this->check_option ('border-top-width','hfont_4_f_style_border_top_width_#4', 'px');
		 //border-bottom
		 $this->check_option ('border-bottom-color','hfont_4_f_style_border_bottom_color_#4', null);
		 $this->check_option ('border-bottom-style','hfont_4_f_style_border_bottom_style_#4', null);
		 $this->check_option ('border-bottom-width','hfont_4_f_style_border_bottom_width_#4', 'px');
		 //border-right
		 $this->check_option ('border-right-color','hfont_4_f_style_border_right_color_#4', null);
		 $this->check_option ('border-right-style','hfont_4_f_style_border_right_style_#4', null);
		 $this->check_option ('border-right-width','hfont_4_f_style_border_right_width_#4', 'px');
		 //border-left
		 $this->check_option ('border-left-color','hfont_4_f_style_border_left_color_#4', null);
		 $this->check_option ('border-left-style','hfont_4_f_style_border_left_style_#4', null);
		 $this->check_option ('border-left-width','hfont_4_f_style_border_left_width_#4', 'px');
		 //border-radius
		 if (get_option('hfont_4_f_style_border_radius_value_#4') != '') {
		 	echo 'border-radius:' . get_option('hfont_4_f_style_border_radius_value_#4') . get_option('hfont_4_f_style_border_radius_value_unit_#4') . ' !important;';
		 }
		 //padding
		 $this->check_option ('padding-top','hfont_4_f_style_padding_top_#4','px');
		 $this->check_option ('padding-bottom','hfont_4_f_style_padding_bottom_#4','px');
		 $this->check_option ('padding-right','hfont_4_f_style_padding_right_#4','px');
		 $this->check_option ('padding-left','hfont_4_f_style_padding_left_#4','px');
		 //margin
		 $this->check_option ('margin-top','hfont_4_f_style_margin_top_#4','px');
		 $this->check_option ('margin-bottom','hfont_4_f_style_margin_bottom_#4','px');
		 $this->check_option ('margin-right','hfont_4_f_style_margin_right_#4','px');
		 $this->check_option ('margin-left','hfont_4_f_style_margin_left_#4','px');		 
		 //background
		 $this->check_option ('background-color','hfont_4_f_style_background_color_#4', null);
		 //text-align
		 $this->check_option ('text-align','hfont_4_f_style_textalign_#4', null);

		 //End h4 codes
		 echo '}';
		}

		# Heading 5 Is Enable
		if ( $chk_h5_enable == 'Enable' ) 
		{ ?>
		div h5, h5{font-family:"<?php echo get_option( 'h5_font' ); ?>" !important;font-size:<?php echo get_option('h5_font_size');echo get_option('h5_font_unit');?> !important;
		<?php
		if (get_option('h5_font_color_enable') == 'Yes' ) 
		{
			echo 'color:#' . get_option('h5_font_color') . ' !important;';
		 }  
		 		 		 // New Style For Option Check
		 $this->check_option ('line-height','h5_font_line_height', '%');
		 //border-top
		 $this->check_option ('border-top-color','hfont_5_f_style_border_top_color_#5', null);
		 $this->check_option ('border-top-style','hfont_5_f_style_border_top_style_#5', null);
		 $this->check_option ('border-top-width','hfont_5_f_style_border_top_width_#5', 'px');
		 //border-bottom
		 $this->check_option ('border-bottom-color','hfont_5_f_style_border_bottom_color_#5', null);
		 $this->check_option ('border-bottom-style','hfont_5_f_style_border_bottom_style_#5', null);
		 $this->check_option ('border-bottom-width','hfont_5_f_style_border_bottom_width_#5', 'px');
		 //border-right
		 $this->check_option ('border-right-color','hfont_5_f_style_border_right_color_#5', null);
		 $this->check_option ('border-right-style','hfont_5_f_style_border_right_style_#5', null);
		 $this->check_option ('border-right-width','hfont_5_f_style_border_right_width_#5', 'px');
		 //border-left
		 $this->check_option ('border-left-color','hfont_5_f_style_border_left_color_#5', null);
		 $this->check_option ('border-left-style','hfont_5_f_style_border_left_style_#5', null);
		 $this->check_option ('border-left-width','hfont_5_f_style_border_left_width_#5', 'px');
		 //border-radius
		 if (get_option('hfont_5_f_style_border_radius_value_#5') != '') {
		 	echo 'border-radius:' . get_option('hfont_5_f_style_border_radius_value_#5') . get_option('hfont_5_f_style_border_radius_value_unit_#5') . ' !important;';
		 }
		 //padding
		 $this->check_option ('padding-top','hfont_5_f_style_padding_top_#5','px');
		 $this->check_option ('padding-bottom','hfont_5_f_style_padding_bottom_#5','px');
		 $this->check_option ('padding-right','hfont_5_f_style_padding_right_#5','px');
		 $this->check_option ('padding-left','hfont_5_f_style_padding_left_#5','px');
		 //margin
		 $this->check_option ('margin-top','hfont_5_f_style_margin_top_#5','px');
		 $this->check_option ('margin-bottom','hfont_5_f_style_margin_bottom_#5','px');
		 $this->check_option ('margin-right','hfont_5_f_style_margin_right_#5','px');
		 $this->check_option ('margin-left','hfont_5_f_style_margin_left_#5','px');		 
		 //background
		 $this->check_option ('background-color','hfont_5_f_style_background_color_#5', null);
		 //text-align
		 $this->check_option ('text-align','hfont_5_f_style_textalign_#5', null);

		 //End h5 codes
		 echo '}';
		}

		# Heading 6 Is Enable
		if ( $chk_h6_enable == 'Enable' ) 
		{ ?>
		div h6, h6{font-family:"<?php echo get_option( 'h6_font' ); ?>" !important;font-size:<?php echo get_option('h6_font_size');echo get_option('h6_font_unit');?> !important;
		<?php 
		if (get_option('h6_font_color_enable') == 'Yes' ) 
		{
			echo 'color:#' . get_option('h6_font_color') . ' !important;';
		 } 
		 		 		 		 // New Style For Option Check
		 $this->check_option ('line-height','h6_font_line_height', '%');
		 //border-top
		 $this->check_option ('border-top-color','hfont_6_f_style_border_top_color_#6', null);
		 $this->check_option ('border-top-style','hfont_6_f_style_border_top_style_#6', null);
		 $this->check_option ('border-top-width','hfont_6_f_style_border_top_width_#6', 'px');
		 //border-bottom
		 $this->check_option ('border-bottom-color','hfont_6_f_style_border_bottom_color_#6', null);
		 $this->check_option ('border-bottom-style','hfont_6_f_style_border_bottom_style_#6', null);
		 $this->check_option ('border-bottom-width','hfont_6_f_style_border_bottom_width_#6', 'px');
		 //border-right
		 $this->check_option ('border-right-color','hfont_6_f_style_border_right_color_#6', null);
		 $this->check_option ('border-right-style','hfont_6_f_style_border_right_style_#6', null);
		 $this->check_option ('border-right-width','hfont_6_f_style_border_right_width_#6', 'px');
		 //border-left
		 $this->check_option ('border-left-color','hfont_6_f_style_border_left_color_#6', null);
		 $this->check_option ('border-left-style','hfont_6_f_style_border_left_style_#6', null);
		 $this->check_option ('border-left-width','hfont_6_f_style_border_left_width_#6', 'px');
		 //border-radius
		 if (get_option('hfont_6_f_style_border_radius_value_#6') != '') {
		 	echo 'border-radius:' . get_option('hfont_6_f_style_border_radius_value_#6') . get_option('hfont_6_f_style_border_radius_value_unit_#6') . ' !important;';
		 }
		 //padding
		 $this->check_option ('padding-top','hfont_6_f_style_padding_top_#6','px');
		 $this->check_option ('padding-bottom','hfont_6_f_style_padding_bottom_#6','px');
		 $this->check_option ('padding-right','hfont_6_f_style_padding_right_#6','px');
		 $this->check_option ('padding-left','hfont_6_f_style_padding_left_#6','px');
		 //margin
		 $this->check_option ('margin-top','hfont_6_f_style_margin_top_#6','px');
		 $this->check_option ('margin-bottom','hfont_6_f_style_margin_bottom_#6','px');
		 $this->check_option ('margin-right','hfont_6_f_style_margin_right_#6','px');
		 $this->check_option ('margin-left','hfont_6_f_style_margin_left_#6','px');		 
		 //background
		 $this->check_option ('background-color','hfont_6_f_style_background_color_#6', null);
		 //text-align
		 $this->check_option ('text-align','hfont_6_f_style_textalign_#6', null);

		 //End h6 codes
		 echo '}';
		}

		# Main Website Font Is Enable
		if ( $wp_font_main_website_enable == 'Enable' ) 
		{ ?>

		p, ul li, footer, header, nav, span, div, b, strong, a, address, textarea, input, table tbody, table thead, table tfooter, q, button, blockquote, caption, form {font-family:ETmodules, FontAwesome, Icons, typicons, entypo, linecons, "Material Icons", "Mono Social Icons Font", "<?php echo get_option( 'wp_font_main_website' ); ?>" !important;

		<?php }

		echo '</style>';

	} # END IF

	if (get_option('c_css_textarea') == '') 
	{
		return false;
	} else {
		echo '<style type="text/css">' . get_option('c_css_textarea') .'</style>';
	}
  }


	function wp_head_output_custom_font ()
	{

		 # Custom Font Tag Name

		 $check_custom_font_enable_1 = get_option('custom_font_enable_#1');
		 $check_custom_font_enable_2 = get_option('custom_font_enable_#2');
		 $check_custom_font_enable_3 = get_option('custom_font_enable_#3');
		 $check_custom_font_enable_4 = get_option('custom_font_enable_#4');
		 $check_custom_font_enable_5 = get_option('custom_font_enable_#5');
		 $check_custom_font_enable_6 = get_option('custom_font_enable_#6');
		 $check_custom_font_enable_7 = get_option('custom_font_enable_#7');
		 $check_custom_font_enable_8 = get_option('custom_font_enable_#8');
		 $check_custom_font_enable_9 = get_option('custom_font_enable_#9');
		 $check_custom_font_enable_10 = get_option('custom_font_enable_#10');

		 # Global Var
		 $imp = ' !important';

		 # Define Vars

		 // START CUSTOM FONT 1
		 $custom_font_tag_name_1 = get_option( 'custom_font_tag_name_#1' );
		 $custom_font_type_1 = get_option( 'custom_font_type_#1' );
		 $custom_font_type_1_ = '';
		 $custom_font_path_1 = get_option( 'custom_font_path_#1' );
		 #$custom_font_ffamily_1 = get_option( 'custom_font_ffamily_#1' );
		 $custom_font_fsize_1 = get_option( 'custom_font_fsize_#1' );
		 $custom_font_fsize_unit_1 = get_option( 'custom_font_fsize_unit_#1' );
		 #$custom_font_fstyle_1 = get_option( 'custom_font_fstyle_#1' );
		 #$custom_font_fweight_1 = get_option( 'custom_font_fweight_#1' );
		 #$custom_font_fstretch_1 = get_option( 'custom_font_fstretch_#1' );
		 #$custom_font_fline_height_1 = get_option( 'custom_font_fline_height_#1' );
		 #$custom_font_fletter_spacing_1 = get_option( 'custom_font_fletter_spacing_#1' );
		 #$custom_font_fword_spacing_1 = get_option( 'custom_font_fword_spacing_#1' );
		 #$custom_font_fcolor_1 = get_option( 'custom_font_fcolor_#1' );

		 // START CUSTOM FONT 2
		 $custom_font_tag_name_2 = get_option( 'custom_font_tag_name_#2' );
		 $custom_font_type_2 = get_option( 'custom_font_type_#2' );
		 $custom_font_type_2_ = '';
		 $custom_font_path_2 = get_option( 'custom_font_path_#2' );
		 #$custom_font_ffamily_2 = get_option( 'custom_font_ffamily_#2' );
		 $custom_font_fsize_2 = get_option( 'custom_font_fsize_#2' );
		 $custom_font_fsize_unit_2 = get_option( 'custom_font_fsize_unit_#2' );
		 #$custom_font_fstyle_2 = get_option( 'custom_font_fstyle_#2' );
		 #$custom_font_fweight_2 = get_option( 'custom_font_fweight_#2' );
		 #$custom_font_fstretch_2 = get_option( 'custom_font_fstretch_#2' );
		 #$custom_font_fline_height_2 = get_option( 'custom_font_fline_height_#2' );
		 #$custom_font_fletter_spacing_2 = get_option( 'custom_font_fletter_spacing_#2' );
		 #$custom_font_fword_spacing_2 = get_option( 'custom_font_fword_spacing_#2' );
		 #$custom_font_fcolor_2 = get_option( 'custom_font_fcolor_#2' );

		 // START CUSTOM FONT 3
		 $custom_font_tag_name_3 = get_option( 'custom_font_tag_name_#3' );
		 $custom_font_type_3 = get_option( 'custom_font_type_#3' );
		 $custom_font_type_3_ = '';
		 $custom_font_path_3 = get_option( 'custom_font_path_#3' );
		 #$custom_font_ffamily_3 = get_option( 'custom_font_ffamily_#3' );
		 $custom_font_fsize_3 = get_option( 'custom_font_fsize_#3' );
		 $custom_font_fsize_unit_3 = get_option( 'custom_font_fsize_unit_#3' );
		 #$custom_font_fstyle_3 = get_option( 'custom_font_fstyle_#3' );
		 #$custom_font_fweight_3 = get_option( 'custom_font_fweight_#3' );
		 #$custom_font_fstretch_3 = get_option( 'custom_font_fstretch_#3' );
		 #$custom_font_fline_height_3 = get_option( 'custom_font_fline_height_#3' );
		 #$custom_font_fletter_spacing_3 = get_option( 'custom_font_fletter_spacing_#3' );
		 #$custom_font_fword_spacing_3 = get_option( 'custom_font_fword_spacing_#3' );
		 #$custom_font_fcolor_3 = get_option( 'custom_font_fcolor_#3' );


		 // START CUSTOM FONT 4
		 $custom_font_tag_name_4 = get_option( 'custom_font_tag_name_#4' );
		 $custom_font_type_4 = get_option( 'custom_font_type_#4' );
		 $custom_font_type_4_ = '';
		 $custom_font_path_4 = get_option( 'custom_font_path_#4' );
		 #$custom_font_ffamily_4 = get_option( 'custom_font_ffamily_#4' );
		 $custom_font_fsize_4 = get_option( 'custom_font_fsize_#4' );
		 $custom_font_fsize_unit_4 = get_option( 'custom_font_fsize_unit_#4' );
		 #$custom_font_fstyle_4 = get_option( 'custom_font_fstyle_#4' );
		 #$custom_font_fweight_4 = get_option( 'custom_font_fweight_#4' );
		 #$custom_font_fstretch_4 = get_option( 'custom_font_fstretch_#4' );
		 #$custom_font_fline_height_4 = get_option( 'custom_font_fline_height_#4' );
		 #$custom_font_fletter_spacing_4 = get_option( 'custom_font_fletter_spacing_#4' );
		 #$custom_font_fword_spacing_4 = get_option( 'custom_font_fword_spacing_#4' );
		 #$custom_font_fcolor_4 = get_option( 'custom_font_fcolor_#4' );


		 // START CUSTOM FONT 5
		 $custom_font_tag_name_5 = get_option( 'custom_font_tag_name_#5' );
		 $custom_font_type_5 = get_option( 'custom_font_type_#5' );
		 $custom_font_type_5_ = '';
		 $custom_font_path_5 = get_option( 'custom_font_path_#5' );
		 #$custom_font_ffamily_5 = get_option( 'custom_font_ffamily_#5' );
		 $custom_font_fsize_5 = get_option( 'custom_font_fsize_#5' );
		 $custom_font_fsize_unit_5 = get_option( 'custom_font_fsize_unit_#5' );
		 #$custom_font_fstyle_5 = get_option( 'custom_font_fstyle_#5' );
		 #$custom_font_fweight_5 = get_option( 'custom_font_fweight_#5' );
		 #$custom_font_fstretch_5 = get_option( 'custom_font_fstretch_#5' );
		 #$custom_font_fline_height_5 = get_option( 'custom_font_fline_height_#5' );
		 #$custom_font_fletter_spacing_5 = get_option( 'custom_font_fletter_spacing_#5' );
		 #$custom_font_fword_spacing_5 = get_option( 'custom_font_fword_spacing_#5' );
		 #$custom_font_fcolor_5 = get_option( 'custom_font_fcolor_#5' );


		 // START CUSTOM FONT 6
		 $custom_font_tag_name_6 = get_option( 'custom_font_tag_name_#6' );
		 $custom_font_type_6 = get_option( 'custom_font_type_#6' );
		 $custom_font_type_6_ = '';
		 $custom_font_path_6 = get_option( 'custom_font_path_#6' );
		 #$custom_font_ffamily_6 = get_option( 'custom_font_ffamily_#6' );
		 $custom_font_fsize_6 = get_option( 'custom_font_fsize_#6' );
		 $custom_font_fsize_unit_6 = get_option( 'custom_font_fsize_unit_#6' );
		 #$custom_font_fstyle_6 = get_option( 'custom_font_fstyle_#6' );
		 #$custom_font_fweight_6 = get_option( 'custom_font_fweight_#6' );
		 #$custom_font_fstretch_6 = get_option( 'custom_font_fstretch_#6' );
		 #$custom_font_fline_height_6 = get_option( 'custom_font_fline_height_#6' );
		 #$custom_font_fletter_spacing_6 = get_option( 'custom_font_fletter_spacing_#6' );
		 #$custom_font_fword_spacing_6 = get_option( 'custom_font_fword_spacing_#6' );
		 #$custom_font_fcolor_6 = get_option( 'custom_font_fcolor_#6' );


		 // START CUSTOM FONT 7
		 $custom_font_tag_name_7 = get_option( 'custom_font_tag_name_#7' );
		 $custom_font_type_7 = get_option( 'custom_font_type_#7' );
		 $custom_font_type_7_ = '';
		 $custom_font_path_7 = get_option( 'custom_font_path_#7' );
		 #$custom_font_ffamily_7 = get_option( 'custom_font_ffamily_#7' );
		 $custom_font_fsize_7 = get_option( 'custom_font_fsize_#7' );
		 $custom_font_fsize_unit_7 = get_option( 'custom_font_fsize_unit_#7' );
		 #$custom_font_fstyle_7 = get_option( 'custom_font_fstyle_#7' );
		 #$custom_font_fweight_7 = get_option( 'custom_font_fweight_#7' );
		 #$custom_font_fstretch_7 = get_option( 'custom_font_fstretch_#7' );
		 #$custom_font_fline_height_7 = get_option( 'custom_font_fline_height_#7' );
		 #$custom_font_fletter_spacing_7 = get_option( 'custom_font_fletter_spacing_#7' );
		 #$custom_font_fword_spacing_7 = get_option( 'custom_font_fword_spacing_#7' );
		 #$custom_font_fcolor_7 = get_option( 'custom_font_fcolor_#7' );


		 // START CUSTOM FONT 8
		 $custom_font_tag_name_8 = get_option( 'custom_font_tag_name_#8' );
		 $custom_font_type_8 = get_option( 'custom_font_type_#8' );
		 $custom_font_type_8_ = '';
		 $custom_font_path_8 = get_option( 'custom_font_path_#8' );
		 #$custom_font_ffamily_8 = get_option( 'custom_font_ffamily_#8' );
		 $custom_font_fsize_8 = get_option( 'custom_font_fsize_#8' );
		 $custom_font_fsize_unit_8 = get_option( 'custom_font_fsize_unit_#8' );
		 #$custom_font_fstyle_8 = get_option( 'custom_font_fstyle_#8' );
		 #$custom_font_fweight_8 = get_option( 'custom_font_fweight_#8' );
		 #$custom_font_fstretch_8 = get_option( 'custom_font_fstretch_#8' );
		 #$custom_font_fline_height_8 = get_option( 'custom_font_fline_height_#8' );
		 #$custom_font_fletter_spacing_8 = get_option( 'custom_font_fletter_spacing_#8' );
		 #$custom_font_fword_spacing_8 = get_option( 'custom_font_fword_spacing_#8' );
		 #$custom_font_fcolor_8 = get_option( 'custom_font_fcolor_#8' );


		 // START CUSTOM FONT 9
		 $custom_font_tag_name_9 = get_option( 'custom_font_tag_name_#9' );
		 $custom_font_type_9 = get_option( 'custom_font_type_#9' );
		 $custom_font_type_9_ = '';
		 $custom_font_path_9 = get_option( 'custom_font_path_#9' );
		 #$custom_font_ffamily_9 = get_option( 'custom_font_ffamily_#9' );
		 $custom_font_fsize_9 = get_option( 'custom_font_fsize_#9' );
		 $custom_font_fsize_unit_9 = get_option( 'custom_font_fsize_unit_#9' );
		 #$custom_font_fstyle_9 = get_option( 'custom_font_fstyle_#9' );
		 #$custom_font_fweight_9 = get_option( 'custom_font_fweight_#9' );
		 #$custom_font_fstretch_9 = get_option( 'custom_font_fstretch_#9' );
		 #$custom_font_fline_height_9 = get_option( 'custom_font_fline_height_#9' );
		 #$custom_font_fletter_spacing_9 = get_option( 'custom_font_fletter_spacing_#9' );
		 #$custom_font_fword_spacing_9 = get_option( 'custom_font_fword_spacing_#9' );
		 #$custom_font_fcolor_9 = get_option( 'custom_font_fcolor_#9' );


		 // START CUSTOM FONT 10
		 $custom_font_tag_name_10 = get_option( 'custom_font_tag_name_#10' );
		 $custom_font_type_10 = get_option( 'custom_font_type_#10' );
		 $custom_font_type_10_ = '';
		 $custom_font_path_10 = get_option( 'custom_font_path_#10' );
		 #$custom_font_ffamily_10 = get_option( 'custom_font_ffamily_#10' );
		 $custom_font_fsize_10 = get_option( 'custom_font_fsize_#10' );
		 $custom_font_fsize_unit_10 = get_option( 'custom_font_fsize_unit_#10' );
		 #$custom_font_fstyle_10 = get_option( 'custom_font_fstyle_#10' );
		 #$custom_font_fweight_10 = get_option( 'custom_font_fweight_#10' );
		 #$custom_font_fstretch_10 = get_option( 'custom_font_fstretch_#10' );
		 #$custom_font_fline_height_10 = get_option( 'custom_font_fline_height_#10' );
		 #$custom_font_fletter_spacing_10 = get_option( 'custom_font_fletter_spacing_#10' );
		 #$custom_font_fword_spacing_10 = get_option( 'custom_font_fword_spacing_#10' );
		 #$custom_font_fcolor_10 = get_option( 'custom_font_fcolor_#10' );


		 // custom_font_type_1
		 if ($custom_font_type_1 == 'ID') {

		 	$custom_font_type_1_ = '#';
		 
		 }

		 if ($custom_font_type_1 == 'Class') {

		 	$custom_font_type_1_ = '.';
		 
		 }
		 // END custom_font_type_1

		 # START IF(s)

		 // custom_font_type_2
		 if ($custom_font_type_2 == 'ID') {

		 	$custom_font_type_2_ = '#';
		 
		 }

		 if ($custom_font_type_2 == 'Class') {

		 	$custom_font_type_2_ = '.';
		 
		 }
		 // END custom_font_type_2

		 // custom_font_type_3
		 if ($custom_font_type_3 == 'ID') {

		 	$custom_font_type_3_ = '#';
		 
		 }

		 if ($custom_font_type_3 == 'Class') {

		 	$custom_font_type_3_ = '.';
		 
		 }
		 // END custom_font_type_3

		 // custom_font_type_4
		 if ($custom_font_type_4 == 'ID') {

		 	$custom_font_type_4_ = '#';
		 
		 }

		 if ($custom_font_type_4 == 'Class') {

		 	$custom_font_type_4_ = '.';
		 
		 }
		 // END custom_font_type_4

		 // custom_font_type_5
		 if ($custom_font_type_5 == 'ID') {

		 	$custom_font_type_5_ = '#';
		 
		 }

		 if ($custom_font_type_5 == 'Class') {

		 	$custom_font_type_5_ = '.';
		 
		 }
		 // END custom_font_type_5

		 // custom_font_type_6
		 if ($custom_font_type_6 == 'ID') {

		 	$custom_font_type_6_ = '#';
		 
		 }

		 if ($custom_font_type_6 == 'Class') {

		 	$custom_font_type_6_ = '.';
		 
		 }
		 // END custom_font_type_6

		 // custom_font_type_7
		 if ($custom_font_type_7 == 'ID') {

		 	$custom_font_type_7_ = '#';
		 
		 }

		 if ($custom_font_type_7 == 'Class') {

		 	$custom_font_type_7_ = '.';
		 
		 }
		 // END custom_font_type_7

		 // custom_font_type_8
		 if ($custom_font_type_8 == 'ID') {

		 	$custom_font_type_8_ = '#';
		 
		 }

		 if ($custom_font_type_8 == 'Class') {

		 	$custom_font_type_8_ = '.';
		 
		 }
		 // END custom_font_type_8

		 // custom_font_type_9
		 if ($custom_font_type_9 == 'ID') {

		 	$custom_font_type_9_ = '#';
		 
		 }

		 if ($custom_font_type_9 == 'Class') {

		 	$custom_font_type_9_ = '.';
		 
		 }
		 // END custom_font_type_9

		 // custom_font_type_10
		 if ($custom_font_type_10 == 'ID') {

		 	$custom_font_type_10_ = '#';
		 
		 }

		 if ($custom_font_type_10 == 'Class') {

		 	$custom_font_type_10_ = '.';
		 
		 }
		 // END custom_font_type_10

		 if ($check_custom_font_enable_1 =='Enable' || $check_custom_font_enable_2 =='Enable' || $check_custom_font_enable_3 =='Enable' || $check_custom_font_enable_4 =='Enable' || $check_custom_font_enable_5 =='Enable' || $check_custom_font_enable_6 =='Enable' || $check_custom_font_enable_7 =='Enable' || $check_custom_font_enable_8 =='Enable' || $check_custom_font_enable_9 =='Enable' || $check_custom_font_enable_10 =='Enable') {
		 	echo '<style type="text/css">';

		 	# if check_custom_font_enable_1 has active status
		 	if ($check_custom_font_enable_1 =='Enable') {

		 	 echo $custom_font_tag_name_1 . $custom_font_type_1_ . $custom_font_path_1 .'{'; 
		 	 if ( get_option('custom_font_fcolor_#1') != ''){
		 	 echo  'color:#' . get_option('custom_font_fcolor_#1') . ' !important;';	
		 	 }

		 	 $this->check_option ('font-family','custom_font_ffamily_#1', null);

		 	 if ( get_option('custom_font_fsize_#1') != ''){
		 	 echo  'font-size:' . $custom_font_fsize_1 . $custom_font_fsize_unit_1 .  ' !important;';	
		 	 }
		 	 $this->check_option ('font-style','custom_font_fstyle_#1', null);
		 	 $this->check_option ('font-weight','custom_font_fweight_#1', null);
		 	 $this->check_option ('font-stretch','custom_font_fstretch_#1', null);
		 	 $this->check_option ('line-height','custom_font_fline_height_#1', '%');
		 	 $this->check_option ('letter-spacing','custom_font_fletter_spacing_#1', 'px');
		 	 $this->check_option ('word-spacing','custom_font_fword_spacing_#1', 'px');

							// New Style For Option Check
			 //border-top
			 $this->check_option ('border-top-color','custom_font_f_style_border_top_color_#1', null);
			 $this->check_option ('border-top-style','custom_font_f_style_border_top_style_#1', null);
			 $this->check_option ('border-top-width','custom_font_f_style_border_top_width_#1', 'px');
			 //border-bottom
			 $this->check_option ('border-bottom-color','custom_font_f_style_border_bottom_color_#1', null);
			 $this->check_option ('border-bottom-style','custom_font_f_style_border_bottom_style_#1', null);
			 $this->check_option ('border-bottom-width','custom_font_f_style_border_bottom_width_#1', 'px');
			 //border-right
			 $this->check_option ('border-right-color','custom_font_f_style_border_right_color_#1', null);
			 $this->check_option ('border-right-style','custom_font_f_style_border_right_style_#1', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#1', 'px');
			 //border-left
			 $this->check_option ('border-left-color','custom_font_f_style_border_right_color_#1', null);
			 $this->check_option ('border-left-style','custom_font_f_style_border_right_style_#1', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#1', 'px');
			 //border-radius
			 if (get_option('custom_font_f_style_border_radius_value_#1') != '') {
			 	echo 'border-radius:' . get_option('custom_font_f_style_border_radius_value_#1') . get_option('custom_font_f_style_border_radius_value_unit_#1') . ' !important;';
			 }
			 //padding
			 $this->check_option ('padding-top','custom_font_f_style_padding_top_#1','px');
			 $this->check_option ('padding-bottom','custom_font_f_style_padding_bottom_#1','px');
			 $this->check_option ('padding-right','custom_font_f_style_padding_right_#1','px');
			 $this->check_option ('padding-left','custom_font_f_style_padding_left_#1','px');
			 //margin
			 $this->check_option ('margin-top','custom_font_f_style_margin_top_#1','px');
			 $this->check_option ('margin-bottom','custom_font_f_style_margin_bottom_#1','px');
			 $this->check_option ('margin-right','custom_font_f_style_margin_right_#1','px');
			 $this->check_option ('margin-left','custom_font_f_style_margin_left_#1','px');		 
			 //background
			 $this->check_option ('background-color','custom_font_f_style_background_color_#1', null);
			 //text-align
			 $this->check_option ('text-align','custom_font_f_style_textalign_#1', null);

			 //End custom font 1 codes
		 	 

		 	 echo '}';
	
		 }

		 	# if check_custom_font_enable_2 has active status
		 	if ($check_custom_font_enable_2 =='Enable') {

		 	echo $custom_font_tag_name_2 . $custom_font_type_2_ . $custom_font_path_2 .'{'; 
		 	 if ( get_option('custom_font_fcolor_#2') != ''){
		 	 echo  'color:#' . get_option('custom_font_fcolor_#2') . ' !important;';	
		 	 }

		 	 $this->check_option ('font-family','custom_font_ffamily_#2', null);

		 	 if ( get_option('custom_font_fsize_#2') != ''){
		 	 echo  'font-size:' . $custom_font_fsize_2 . $custom_font_fsize_unit_2 .  ' !important;';	
		 	 }
		 	 $this->check_option ('font-style','custom_font_fstyle_#2', null);
		 	 $this->check_option ('font-weight','custom_font_fweight_#2', null);
		 	 $this->check_option ('font-stretch','custom_font_fstretch_#2', null);
		 	 $this->check_option ('line-height','custom_font_fline_height_#2', '%');
		 	 $this->check_option ('letter-spacing','custom_font_fletter_spacing_#2', 'px');
		 	 $this->check_option ('word-spacing','custom_font_fword_spacing_#2', 'px');

							// New Style For Option Check
			 //border-top
			 $this->check_option ('border-top-color','custom_font_f_style_border_top_color_#2', null);
			 $this->check_option ('border-top-style','custom_font_f_style_border_top_style_#2', null);
			 $this->check_option ('border-top-width','custom_font_f_style_border_top_width_#2', 'px');
			 //border-bottom
			 $this->check_option ('border-bottom-color','custom_font_f_style_border_bottom_color_#2', null);
			 $this->check_option ('border-bottom-style','custom_font_f_style_border_bottom_style_#2', null);
			 $this->check_option ('border-bottom-width','custom_font_f_style_border_bottom_width_#2', 'px');
			 //border-right
			 $this->check_option ('border-right-color','custom_font_f_style_border_right_color_#2', null);
			 $this->check_option ('border-right-style','custom_font_f_style_border_right_style_#2', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#2', 'px');
			 //border-left
			 $this->check_option ('border-left-color','custom_font_f_style_border_right_color_#2', null);
			 $this->check_option ('border-left-style','custom_font_f_style_border_right_style_#2', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#2', 'px');
			 //border-radius
			 if (get_option('custom_font_f_style_border_radius_value_#2') != '') {
			 	echo 'border-radius:' . get_option('custom_font_f_style_border_radius_value_#2') . get_option('custom_font_f_style_border_radius_value_unit_#2') . ' !important;';
			 }
			 //padding
			 $this->check_option ('padding-top','custom_font_f_style_padding_top_#2','px');
			 $this->check_option ('padding-bottom','custom_font_f_style_padding_bottom_#2','px');
			 $this->check_option ('padding-right','custom_font_f_style_padding_right_#2','px');
			 $this->check_option ('padding-left','custom_font_f_style_padding_left_#2','px');
			 //margin
			 $this->check_option ('margin-top','custom_font_f_style_margin_top_#2','px');
			 $this->check_option ('margin-bottom','custom_font_f_style_margin_bottom_#2','px');
			 $this->check_option ('margin-right','custom_font_f_style_margin_right_#2','px');
			 $this->check_option ('margin-left','custom_font_f_style_margin_left_#2','px');		 
			 //background
			 $this->check_option ('background-color','custom_font_f_style_background_color_#2', null);
			 //text-align
			 $this->check_option ('text-align','custom_font_f_style_textalign_#2', null);

			 //End custom font 2 codes
		 	 
		 	 echo '}';
	
		 }

		 	# if check_custom_font_enable_3 has active status
		 	if ($check_custom_font_enable_3 =='Enable') {

		 	 echo $custom_font_tag_name_3 . $custom_font_type_3_ . $custom_font_path_3 .'{'; 

		 	 if ( get_option('custom_font_fcolor_#3') != ''){
		 	 echo  'color:#' . get_option('custom_font_fcolor_#3') . ' !important;';	
		 	 }

		 	 $this->check_option ('font-family','custom_font_ffamily_#3', null);

		 	 if ( get_option('custom_font_fsize_#3') != ''){
		 	 echo  'font-size:' . $custom_font_fsize_3 . $custom_font_fsize_unit_3 .  ' !important;';	
		 	 }
		 	 $this->check_option ('font-style','custom_font_fstyle_#3', null);
		 	 $this->check_option ('font-weight','custom_font_fweight_#3', null);
		 	 $this->check_option ('font-stretch','custom_font_fstretch_#3', null);
		 	 $this->check_option ('line-height','custom_font_fline_height_#3', '%');
		 	 $this->check_option ('letter-spacing','custom_font_fletter_spacing_#3', 'px');
		 	 $this->check_option ('word-spacing','custom_font_fword_spacing_#3', 'px');

							// New Style For Option Check
			 //border-top
			 $this->check_option ('border-top-color','custom_font_f_style_border_top_color_#3', null);
			 $this->check_option ('border-top-style','custom_font_f_style_border_top_style_#3', null);
			 $this->check_option ('border-top-width','custom_font_f_style_border_top_width_#3', 'px');
			 //border-bottom
			 $this->check_option ('border-bottom-color','custom_font_f_style_border_bottom_color_#3', null);
			 $this->check_option ('border-bottom-style','custom_font_f_style_border_bottom_style_#3', null);
			 $this->check_option ('border-bottom-width','custom_font_f_style_border_bottom_width_#3', 'px');
			 //border-right
			 $this->check_option ('border-right-color','custom_font_f_style_border_right_color_#3', null);
			 $this->check_option ('border-right-style','custom_font_f_style_border_right_style_#3', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#3', 'px');
			 //border-left
			 $this->check_option ('border-left-color','custom_font_f_style_border_right_color_#3', null);
			 $this->check_option ('border-left-style','custom_font_f_style_border_right_style_#3', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#3', 'px');
			 //border-radius
			 if (get_option('custom_font_f_style_border_radius_value_#3') != '') {
			 	echo 'border-radius:' . get_option('custom_font_f_style_border_radius_value_#3') . get_option('custom_font_f_style_border_radius_value_unit_#3') . ' !important;';
			 }
			 //padding
			 $this->check_option ('padding-top','custom_font_f_style_padding_top_#3','px');
			 $this->check_option ('padding-bottom','custom_font_f_style_padding_bottom_#3','px');
			 $this->check_option ('padding-right','custom_font_f_style_padding_right_#3','px');
			 $this->check_option ('padding-left','custom_font_f_style_padding_left_#3','px');
			 //margin
			 $this->check_option ('margin-top','custom_font_f_style_margin_top_#3','px');
			 $this->check_option ('margin-bottom','custom_font_f_style_margin_bottom_#3','px');
			 $this->check_option ('margin-right','custom_font_f_style_margin_right_#3','px');
			 $this->check_option ('margin-left','custom_font_f_style_margin_left_#3','px');		 
			 //background
			 $this->check_option ('background-color','custom_font_f_style_background_color_#3', null);
			 //text-align
			 $this->check_option ('text-align','custom_font_f_style_textalign_#3', null);

			 //End custom font 3 codes
		 	 
		 	 echo '}';
	
		 }

		 	# if check_custom_font_enable_4 has active status
		 	if ($check_custom_font_enable_4 =='Enable') {

		 	 		 	echo $custom_font_tag_name_4 . $custom_font_type_4_ . $custom_font_path_4 .'{'; 
		 	 if ( get_option('custom_font_fcolor_#4') != ''){
		 	 echo  'color:#' . get_option('custom_font_fcolor_#4') . ' !important;';	
		 	 }

		 	 $this->check_option ('font-family','custom_font_ffamily_#4', null);

		 	 if ( get_option('custom_font_fsize_#4') != ''){
		 	 echo  'font-size:' . $custom_font_fsize_4 . $custom_font_fsize_unit_4 .  ' !important;';	
		 	 }
		 	 $this->check_option ('font-style','custom_font_fstyle_#4', null);
		 	 $this->check_option ('font-weight','custom_font_fweight_#4', null);
		 	 $this->check_option ('font-stretch','custom_font_fstretch_#4', null);
		 	 $this->check_option ('line-height','custom_font_fline_height_#4', '%');
		 	 $this->check_option ('letter-spacing','custom_font_fletter_spacing_#4', 'px');
		 	 $this->check_option ('word-spacing','custom_font_fword_spacing_#4', 'px');

							// New Style For Option Check
			 //border-top
			 $this->check_option ('border-top-color','custom_font_f_style_border_top_color_#4', null);
			 $this->check_option ('border-top-style','custom_font_f_style_border_top_style_#4', null);
			 $this->check_option ('border-top-width','custom_font_f_style_border_top_width_#4', 'px');
			 //border-bottom
			 $this->check_option ('border-bottom-color','custom_font_f_style_border_bottom_color_#4', null);
			 $this->check_option ('border-bottom-style','custom_font_f_style_border_bottom_style_#4', null);
			 $this->check_option ('border-bottom-width','custom_font_f_style_border_bottom_width_#4', 'px');
			 //border-right
			 $this->check_option ('border-right-color','custom_font_f_style_border_right_color_#4', null);
			 $this->check_option ('border-right-style','custom_font_f_style_border_right_style_#4', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#4', 'px');
			 //border-left
			 $this->check_option ('border-left-color','custom_font_f_style_border_right_color_#4', null);
			 $this->check_option ('border-left-style','custom_font_f_style_border_right_style_#4', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#4', 'px');
			 //border-radius
			 if (get_option('custom_font_f_style_border_radius_value_#4') != '') {
			 	echo 'border-radius:' . get_option('custom_font_f_style_border_radius_value_#4') . get_option('custom_font_f_style_border_radius_value_unit_#4') . ' !important;';
			 }
			 //padding
			 $this->check_option ('padding-top','custom_font_f_style_padding_top_#4','px');
			 $this->check_option ('padding-bottom','custom_font_f_style_padding_bottom_#4','px');
			 $this->check_option ('padding-right','custom_font_f_style_padding_right_#4','px');
			 $this->check_option ('padding-left','custom_font_f_style_padding_left_#4','px');
			 //margin
			 $this->check_option ('margin-top','custom_font_f_style_margin_top_#4','px');
			 $this->check_option ('margin-bottom','custom_font_f_style_margin_bottom_#4','px');
			 $this->check_option ('margin-right','custom_font_f_style_margin_right_#4','px');
			 $this->check_option ('margin-left','custom_font_f_style_margin_left_#4','px');		 
			 //background
			 $this->check_option ('background-color','custom_font_f_style_background_color_#4', null);
			 //text-align
			 $this->check_option ('text-align','custom_font_f_style_textalign_#4', null);

			 //End custom font 4 codes
		 	 
		 	 echo '}';
	
		 }
		 
		 	# if check_custom_font_enable_5 has active status
		 	if ($check_custom_font_enable_5 =='Enable') {

		 	 		 	echo $custom_font_tag_name_5 . $custom_font_type_5_ . $custom_font_path_5 .'{'; 
		 	 if ( get_option('custom_font_fcolor_#5') != ''){
		 	 echo  'color:#' . get_option('custom_font_fcolor_#5') . ' !important;';	
		 	 }

		 	 $this->check_option ('font-family','custom_font_ffamily_#5', null);

		 	 if ( get_option('custom_font_fsize_#5') != ''){
		 	 echo  'font-size:' . $custom_font_fsize_5 . $custom_font_fsize_unit_5 .  ' !important;';	
		 	 }
		 	 $this->check_option ('font-style','custom_font_fstyle_#5', null);
		 	 $this->check_option ('font-weight','custom_font_fweight_#5', null);
		 	 $this->check_option ('font-stretch','custom_font_fstretch_#5', null);
		 	 $this->check_option ('line-height','custom_font_fline_height_#5', '%');
		 	 $this->check_option ('letter-spacing','custom_font_fletter_spacing_#5', 'px');
		 	 $this->check_option ('word-spacing','custom_font_fword_spacing_#5', 'px');

							// New Style For Option Check
			 //border-top
			 $this->check_option ('border-top-color','custom_font_f_style_border_top_color_#5', null);
			 $this->check_option ('border-top-style','custom_font_f_style_border_top_style_#5', null);
			 $this->check_option ('border-top-width','custom_font_f_style_border_top_width_#5', 'px');
			 //border-bottom
			 $this->check_option ('border-bottom-color','custom_font_f_style_border_bottom_color_#5', null);
			 $this->check_option ('border-bottom-style','custom_font_f_style_border_bottom_style_#5', null);
			 $this->check_option ('border-bottom-width','custom_font_f_style_border_bottom_width_#5', 'px');
			 //border-right
			 $this->check_option ('border-right-color','custom_font_f_style_border_right_color_#5', null);
			 $this->check_option ('border-right-style','custom_font_f_style_border_right_style_#5', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#5', 'px');
			 //border-left
			 $this->check_option ('border-left-color','custom_font_f_style_border_right_color_#5', null);
			 $this->check_option ('border-left-style','custom_font_f_style_border_right_style_#5', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#5', 'px');
			 //border-radius
			 if (get_option('custom_font_f_style_border_radius_value_#5') != '') {
			 	echo 'border-radius:' . get_option('custom_font_f_style_border_radius_value_#5') . get_option('custom_font_f_style_border_radius_value_unit_#5') . ' !important;';
			 }
			 //padding
			 $this->check_option ('padding-top','custom_font_f_style_padding_top_#5','px');
			 $this->check_option ('padding-bottom','custom_font_f_style_padding_bottom_#5','px');
			 $this->check_option ('padding-right','custom_font_f_style_padding_right_#5','px');
			 $this->check_option ('padding-left','custom_font_f_style_padding_left_#5','px');
			 //margin
			 $this->check_option ('margin-top','custom_font_f_style_margin_top_#5','px');
			 $this->check_option ('margin-bottom','custom_font_f_style_margin_bottom_#5','px');
			 $this->check_option ('margin-right','custom_font_f_style_margin_right_#5','px');
			 $this->check_option ('margin-left','custom_font_f_style_margin_left_#5','px');		 
			 //background
			 $this->check_option ('background-color','custom_font_f_style_background_color_#5', null);
			 //text-align
			 $this->check_option ('text-align','custom_font_f_style_textalign_#5', null);

			 //End custom font 5 codes
		 	 
		 	 echo '}';
	
		 }
		 
		 	# if check_custom_font_enable_6 has active status
		 	if ($check_custom_font_enable_6 =='Enable') {

		 	echo $custom_font_tag_name_6 . $custom_font_type_6_ . $custom_font_path_6 .'{'; 
		 	 if ( get_option('custom_font_fcolor_#6') != ''){
		 	 echo  'color:#' . get_option('custom_font_fcolor_#6') . ' !important;';	
		 	 }

		 	 $this->check_option ('font-family','custom_font_ffamily_#6', null);

		 	 if ( get_option('custom_font_fsize_#6') != ''){
		 	 echo  'font-size:' . $custom_font_fsize_6 . $custom_font_fsize_unit_6 .  ' !important;';	
		 	 }
		 	 $this->check_option ('font-style','custom_font_fstyle_#6', null);
		 	 $this->check_option ('font-weight','custom_font_fweight_#6', null);
		 	 $this->check_option ('font-stretch','custom_font_fstretch_#6', null);
		 	 $this->check_option ('line-height','custom_font_fline_height_#6', '%');
		 	 $this->check_option ('letter-spacing','custom_font_fletter_spacing_#6', 'px');
		 	 $this->check_option ('word-spacing','custom_font_fword_spacing_#6', 'px');

							// New Style For Option Check
			 //border-top
			 $this->check_option ('border-top-color','custom_font_f_style_border_top_color_#6', null);
			 $this->check_option ('border-top-style','custom_font_f_style_border_top_style_#6', null);
			 $this->check_option ('border-top-width','custom_font_f_style_border_top_width_#6', 'px');
			 //border-bottom
			 $this->check_option ('border-bottom-color','custom_font_f_style_border_bottom_color_#6', null);
			 $this->check_option ('border-bottom-style','custom_font_f_style_border_bottom_style_#6', null);
			 $this->check_option ('border-bottom-width','custom_font_f_style_border_bottom_width_#6', 'px');
			 //border-right
			 $this->check_option ('border-right-color','custom_font_f_style_border_right_color_#6', null);
			 $this->check_option ('border-right-style','custom_font_f_style_border_right_style_#6', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#6', 'px');
			 //border-left
			 $this->check_option ('border-left-color','custom_font_f_style_border_right_color_#6', null);
			 $this->check_option ('border-left-style','custom_font_f_style_border_right_style_#6', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#6', 'px');
			 //border-radius
			 if (get_option('custom_font_f_style_border_radius_value_#6') != '') {
			 	echo 'border-radius:' . get_option('custom_font_f_style_border_radius_value_#6') . get_option('custom_font_f_style_border_radius_value_unit_#6') . ' !important;';
			 }
			 //padding
			 $this->check_option ('padding-top','custom_font_f_style_padding_top_#6','px');
			 $this->check_option ('padding-bottom','custom_font_f_style_padding_bottom_#6','px');
			 $this->check_option ('padding-right','custom_font_f_style_padding_right_#6','px');
			 $this->check_option ('padding-left','custom_font_f_style_padding_left_#6','px');
			 //margin
			 $this->check_option ('margin-top','custom_font_f_style_margin_top_#6','px');
			 $this->check_option ('margin-bottom','custom_font_f_style_margin_bottom_#6','px');
			 $this->check_option ('margin-right','custom_font_f_style_margin_right_#6','px');
			 $this->check_option ('margin-left','custom_font_f_style_margin_left_#6','px');		 
			 //background
			 $this->check_option ('background-color','custom_font_f_style_background_color_#6', null);
			 //text-align
			 $this->check_option ('text-align','custom_font_f_style_textalign_#6', null);

			 //End custom font 6 codes
		 	 
		 	 echo '}';
	
		 }
		 
		 	# if check_custom_font_enable_7 has active status
		 	if ($check_custom_font_enable_7 =='Enable') {

		 	 echo $custom_font_tag_name_7 . $custom_font_type_7_ . $custom_font_path_7 .'{'; 
		 	 if ( get_option('custom_font_fcolor_#7') != ''){
		 	 echo  'color:#' . get_option('custom_font_fcolor_#7') . ' !important;';	
		 	 }

		 	 $this->check_option ('font-family','custom_font_ffamily_#7', null);

		 	 if ( get_option('custom_font_fsize_#7') != ''){
		 	 echo  'font-size:' . $custom_font_fsize_7 . $custom_font_fsize_unit_7 .  ' !important;';	
		 	 }
		 	 $this->check_option ('font-style','custom_font_fstyle_#7', null);
		 	 $this->check_option ('font-weight','custom_font_fweight_#7', null);
		 	 $this->check_option ('font-stretch','custom_font_fstretch_#7', null);
		 	 $this->check_option ('line-height','custom_font_fline_height_#7', '%');
		 	 $this->check_option ('letter-spacing','custom_font_fletter_spacing_#7', 'px');
		 	 $this->check_option ('word-spacing','custom_font_fword_spacing_#7', 'px');

							// New Style For Option Check
			 //border-top
			 $this->check_option ('border-top-color','custom_font_f_style_border_top_color_#7', null);
			 $this->check_option ('border-top-style','custom_font_f_style_border_top_style_#7', null);
			 $this->check_option ('border-top-width','custom_font_f_style_border_top_width_#7', 'px');
			 //border-bottom
			 $this->check_option ('border-bottom-color','custom_font_f_style_border_bottom_color_#7', null);
			 $this->check_option ('border-bottom-style','custom_font_f_style_border_bottom_style_#7', null);
			 $this->check_option ('border-bottom-width','custom_font_f_style_border_bottom_width_#7', 'px');
			 //border-right
			 $this->check_option ('border-right-color','custom_font_f_style_border_right_color_#7', null);
			 $this->check_option ('border-right-style','custom_font_f_style_border_right_style_#7', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#7', 'px');
			 //border-left
			 $this->check_option ('border-left-color','custom_font_f_style_border_right_color_#7', null);
			 $this->check_option ('border-left-style','custom_font_f_style_border_right_style_#7', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#7', 'px');
			 //border-radius
			 if (get_option('custom_font_f_style_border_radius_value_#7') != '') {
			 	echo 'border-radius:' . get_option('custom_font_f_style_border_radius_value_#7') . get_option('custom_font_f_style_border_radius_value_unit_#7') . ' !important;';
			 }
			 //padding
			 $this->check_option ('padding-top','custom_font_f_style_padding_top_#7','px');
			 $this->check_option ('padding-bottom','custom_font_f_style_padding_bottom_#7','px');
			 $this->check_option ('padding-right','custom_font_f_style_padding_right_#7','px');
			 $this->check_option ('padding-left','custom_font_f_style_padding_left_#7','px');
			 //margin
			 $this->check_option ('margin-top','custom_font_f_style_margin_top_#7','px');
			 $this->check_option ('margin-bottom','custom_font_f_style_margin_bottom_#7','px');
			 $this->check_option ('margin-right','custom_font_f_style_margin_right_#7','px');
			 $this->check_option ('margin-left','custom_font_f_style_margin_left_#7','px');		 
			 //background
			 $this->check_option ('background-color','custom_font_f_style_background_color_#7', null);
			 //text-align
			 $this->check_option ('text-align','custom_font_f_style_textalign_#7', null);

			 //End custom font 7 codes
		 	 
		 	 echo '}';
	
		 }
		 
		 	# if check_custom_font_enable_8 has active status
		 	if ($check_custom_font_enable_8 =='Enable') {

		 	 echo $custom_font_tag_name_8 . $custom_font_type_8_ . $custom_font_path_8 .'{'; 
		 	 if ( get_option('custom_font_fcolor_#8') != ''){
		 	 echo  'color:#' . get_option('custom_font_fcolor_#8') . ' !important;';	
		 	 }

		 	 $this->check_option ('font-family','custom_font_ffamily_#8', null);

		 	 if ( get_option('custom_font_fsize_#8') != ''){
		 	 echo  'font-size:' . $custom_font_fsize_8 . $custom_font_fsize_unit_8 .  ' !important;';	
		 	 }
		 	 $this->check_option ('font-style','custom_font_fstyle_#8', null);
		 	 $this->check_option ('font-weight','custom_font_fweight_#8', null);
		 	 $this->check_option ('font-stretch','custom_font_fstretch_#8', null);
		 	 $this->check_option ('line-height','custom_font_fline_height_#8', '%');
		 	 $this->check_option ('letter-spacing','custom_font_fletter_spacing_#8', 'px');
		 	 $this->check_option ('word-spacing','custom_font_fword_spacing_#8', 'px');

							// New Style For Option Check
			 //border-top
			 $this->check_option ('border-top-color','custom_font_f_style_border_top_color_#8', null);
			 $this->check_option ('border-top-style','custom_font_f_style_border_top_style_#8', null);
			 $this->check_option ('border-top-width','custom_font_f_style_border_top_width_#8', 'px');
			 //border-bottom
			 $this->check_option ('border-bottom-color','custom_font_f_style_border_bottom_color_#8', null);
			 $this->check_option ('border-bottom-style','custom_font_f_style_border_bottom_style_#8', null);
			 $this->check_option ('border-bottom-width','custom_font_f_style_border_bottom_width_#8', 'px');
			 //border-right
			 $this->check_option ('border-right-color','custom_font_f_style_border_right_color_#8', null);
			 $this->check_option ('border-right-style','custom_font_f_style_border_right_style_#8', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#8', 'px');
			 //border-left
			 $this->check_option ('border-left-color','custom_font_f_style_border_right_color_#8', null);
			 $this->check_option ('border-left-style','custom_font_f_style_border_right_style_#8', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#8', 'px');
			 //border-radius
			 if (get_option('custom_font_f_style_border_radius_value_#8') != '') {
			 	echo 'border-radius:' . get_option('custom_font_f_style_border_radius_value_#8') . get_option('custom_font_f_style_border_radius_value_unit_#8') . ' !important;';
			 }
			 //padding
			 $this->check_option ('padding-top','custom_font_f_style_padding_top_#8','px');
			 $this->check_option ('padding-bottom','custom_font_f_style_padding_bottom_#8','px');
			 $this->check_option ('padding-right','custom_font_f_style_padding_right_#8','px');
			 $this->check_option ('padding-left','custom_font_f_style_padding_left_#8','px');
			 //margin
			 $this->check_option ('margin-top','custom_font_f_style_margin_top_#8','px');
			 $this->check_option ('margin-bottom','custom_font_f_style_margin_bottom_#8','px');
			 $this->check_option ('margin-right','custom_font_f_style_margin_right_#8','px');
			 $this->check_option ('margin-left','custom_font_f_style_margin_left_#8','px');		 
			 //background
			 $this->check_option ('background-color','custom_font_f_style_background_color_#8', null);
			 //text-align
			 $this->check_option ('text-align','custom_font_f_style_textalign_#8', null);

			 //End custom font 8 codes
		 	 
		 	 echo '}';
	
		 }
		 
		 	# if check_custom_font_enable_9 has active status
		 	if ($check_custom_font_enable_9 =='Enable') {

		 	 echo $custom_font_tag_name_9 . $custom_font_type_9_ . $custom_font_path_9 .'{'; 
		 	 if ( get_option('custom_font_fcolor_#9') != ''){
		 	 echo  'color:#' . get_option('custom_font_fcolor_#9') . ' !important;';	
		 	 }

		 	 $this->check_option ('font-family','custom_font_ffamily_#9', null);

		 	 if ( get_option('custom_font_fsize_#9') != ''){
		 	 echo  'font-size:' . $custom_font_fsize_9 . $custom_font_fsize_unit_9 .  ' !important;';	
		 	 }
		 	 $this->check_option ('font-style','custom_font_fstyle_#9', null);
		 	 $this->check_option ('font-weight','custom_font_fweight_#9', null);
		 	 $this->check_option ('font-stretch','custom_font_fstretch_#9', null);
		 	 $this->check_option ('line-height','custom_font_fline_height_#9', '%');
		 	 $this->check_option ('letter-spacing','custom_font_fletter_spacing_#9', 'px');
		 	 $this->check_option ('word-spacing','custom_font_fword_spacing_#9', 'px');

							// New Style For Option Check
			 //border-top
			 $this->check_option ('border-top-color','custom_font_f_style_border_top_color_#9', null);
			 $this->check_option ('border-top-style','custom_font_f_style_border_top_style_#9', null);
			 $this->check_option ('border-top-width','custom_font_f_style_border_top_width_#9', 'px');
			 //border-bottom
			 $this->check_option ('border-bottom-color','custom_font_f_style_border_bottom_color_#9', null);
			 $this->check_option ('border-bottom-style','custom_font_f_style_border_bottom_style_#9', null);
			 $this->check_option ('border-bottom-width','custom_font_f_style_border_bottom_width_#9', 'px');
			 //border-right
			 $this->check_option ('border-right-color','custom_font_f_style_border_right_color_#9', null);
			 $this->check_option ('border-right-style','custom_font_f_style_border_right_style_#9', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#9', 'px');
			 //border-left
			 $this->check_option ('border-left-color','custom_font_f_style_border_right_color_#9', null);
			 $this->check_option ('border-left-style','custom_font_f_style_border_right_style_#9', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#9', 'px');
			 //border-radius
			 if (get_option('custom_font_f_style_border_radius_value_#9') != '') {
			 	echo 'border-radius:' . get_option('custom_font_f_style_border_radius_value_#9') . get_option('custom_font_f_style_border_radius_value_unit_#9') . ' !important;';
			 }
			 //padding
			 $this->check_option ('padding-top','custom_font_f_style_padding_top_#9','px');
			 $this->check_option ('padding-bottom','custom_font_f_style_padding_bottom_#9','px');
			 $this->check_option ('padding-right','custom_font_f_style_padding_right_#9','px');
			 $this->check_option ('padding-left','custom_font_f_style_padding_left_#9','px');
			 //margin
			 $this->check_option ('margin-top','custom_font_f_style_margin_top_#9','px');
			 $this->check_option ('margin-bottom','custom_font_f_style_margin_bottom_#9','px');
			 $this->check_option ('margin-right','custom_font_f_style_margin_right_#9','px');
			 $this->check_option ('margin-left','custom_font_f_style_margin_left_#9','px');		 
			 //background
			 $this->check_option ('background-color','custom_font_f_style_background_color_#9', null);
			 //text-align
			 $this->check_option ('text-align','custom_font_f_style_textalign_#9', null);

			 //End custom font 10 codes
		 	 
		 	 echo '}';
	
		 }
		 
		 	# if check_custom_font_enable_10 has active status
		 	if ($check_custom_font_enable_10 =='Enable') {

		 	 echo $custom_font_tag_name_10 . $custom_font_type_10_ . $custom_font_path_10 .'{'; 

		 	 if ( get_option('custom_font_fcolor_#10') != ''){
		 	 echo  'color:#' . get_option('custom_font_fcolor_#10') . ' !important;';	
		 	 }

		 	 $this->check_option ('font-family','custom_font_ffamily_#10', null);

		 	 if ( get_option('custom_font_fsize_#10') != ''){
		 	 echo  'font-size:' . $custom_font_fsize_10 . $custom_font_fsize_unit_10 .  ' !important;';	
		 	 }
		 	 $this->check_option ('font-style','custom_font_fstyle_#10', null);
		 	 $this->check_option ('font-weight','custom_font_fweight_#10', null);
		 	 $this->check_option ('font-stretch','custom_font_fstretch_#10', null);
		 	 $this->check_option ('line-height','custom_font_fline_height_#10', '%');
		 	 $this->check_option ('letter-spacing','custom_font_fletter_spacing_#10', 'px');
		 	 $this->check_option ('word-spacing','custom_font_fword_spacing_#10', 'px');

							// New Style For Option Check
			 //border-top
			 $this->check_option ('border-top-color','custom_font_f_style_border_top_color_#10', null);
			 $this->check_option ('border-top-style','custom_font_f_style_border_top_style_#10', null);
			 $this->check_option ('border-top-width','custom_font_f_style_border_top_width_#10', 'px');
			 //border-bottom
			 $this->check_option ('border-bottom-color','custom_font_f_style_border_bottom_color_#10', null);
			 $this->check_option ('border-bottom-style','custom_font_f_style_border_bottom_style_#10', null);
			 $this->check_option ('border-bottom-width','custom_font_f_style_border_bottom_width_#10', 'px');
			 //border-right
			 $this->check_option ('border-right-color','custom_font_f_style_border_right_color_#10', null);
			 $this->check_option ('border-right-style','custom_font_f_style_border_right_style_#10', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#10', 'px');
			 //border-left
			 $this->check_option ('border-left-color','custom_font_f_style_border_right_color_#10', null);
			 $this->check_option ('border-left-style','custom_font_f_style_border_right_style_#10', null);
			 $this->check_option ('border-right-width','custom_font_f_style_border_right_width_#10', 'px');
			 //border-radius
			 if (get_option('custom_font_f_style_border_radius_value_#10') != '') {
			 	echo 'border-radius:' . get_option('custom_font_f_style_border_radius_value_#10') . get_option('custom_font_f_style_border_radius_value_unit_#10') . ' !important;';
			 }
			 //padding
			 $this->check_option ('padding-top','custom_font_f_style_padding_top_#10','px');
			 $this->check_option ('padding-bottom','custom_font_f_style_padding_bottom_#10','px');
			 $this->check_option ('padding-right','custom_font_f_style_padding_right_#10','px');
			 $this->check_option ('padding-left','custom_font_f_style_padding_left_#10','px');
			 //margin
			 $this->check_option ('margin-top','custom_font_f_style_margin_top_#10','px');
			 $this->check_option ('margin-bottom','custom_font_f_style_margin_bottom_#10','px');
			 $this->check_option ('margin-right','custom_font_f_style_margin_right_#10','px');
			 $this->check_option ('margin-left','custom_font_f_style_margin_left_#10','px');		 
			 //background
			 $this->check_option ('background-color','custom_font_f_style_background_color_#10', null);
			 //text-align
			 $this->check_option ('text-align','custom_font_f_style_textalign_#10', null);

			 //End custom font 10 codes
		 	 
		 	 echo '}';
	
		 }

		 echo '</style>';
		}
		
	}

	function main_wp_panel_font ()
	{
	?>
	<style type="text/css">
	.wp-menu-name, select, input, textarea, label, body, html, .rtl #wpadminbar *, #poststuff, div#post-body-content, #poststuff .stuffbox > h3, #poststuff h2, #poststuff h3.hndle, .rtl h1, .rtl h2, .rtl h3, .rtl h4, .rtl h5, .rtl h6, .wrap h1.wp-heading-inline, .form-table th, .form-table td p, .form-table td fieldset label, #adminmenuwrap *, body.rtl, select * option {font-family: <?php echo get_option( 'wp_font' );?>,dashicons !important;}
	#adminmenu div.wp-menu-name {color:#<?php echo get_option( 'wp_font_panel_color' );?> !important;}
	#adminmenu div.wp-menu-arrow {background:#<?php echo get_option( 'wp_font_panel_color_bg_active' );?> !important;}
	#adminmenu .wp-has-current-submenu .wp-submenu .wp-submenu-head, #adminmenu .wp-menu-arrow, #adminmenu .wp-menu-arrow div, #adminmenu li.current a.menu-top, #adminmenu li.wp-has-current-submenu a.wp-has-current-submenu, .folded #adminmenu li.current.menu-top, .folded #adminmenu li.wp-has-current-submenu{background:#<?php echo get_option( 'wp_font_panel_color_bg_active' );?> !important;}
	#adminmenu .wp-has-current-submenu .wp-submenu .wp-submenu-head {color:#<?php echo get_option( 'wp_font_panel_color' );?> !important;}
	</style>	

<?php	
}

// End Class
}
?>